package com.digiwin.mobile.mobileuibot.dto;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>功能描述：分页请求 基类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BasePageDto.java
 * @Author: wangjwc
 * @Date: created at 2025/8/8 16:58
 */
@Data
@Accessors(chain = true)
public abstract class BasePageDto implements Serializable {
    private static final long serialVersionUID = -7495781275654456929L;
    // 当前页数 默认为1
    private Integer pageNum = 1;
    // 每页数量 默认为10
    private Integer pageSize = 10;
    // 起始
    private Integer startRow;

    public Integer getPageNum() {
        if (pageNum == null || pageNum < 1) {
            return 1;
        }
        return pageNum;
    }

    public Integer getPageSize() {
        if (pageSize == null || pageSize < 1) {
            return pageSize = 10;
        }
        return pageSize;
    }

    public Integer getStartRow() {
        return (getPageNum() - 1) * getPageSize();
    }

}
