package com.digiwin.mobile.mobileuibot.mapper.db1;

import com.digiwin.mobile.mobileuibot.mapper.base.MobileBaseMapper;
import com.digiwin.mobile.mobileuibot.model.db1.PersonalConfiguration;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author wuyang
 */
@Mapper
@Component
public interface PersonalConfigurationMapper extends MobileBaseMapper<PersonalConfiguration> {


    /**
     * 根据 userid、tenantId 获取一条数据
     *
     * @param params
     * @return
     */
    PersonalConfiguration getByMap(Map<String, String> params);

    /**
     * 插入一条数据
     *
     * @param personalConfiguration 实体类
     * @return
     */
    Boolean insertData(PersonalConfiguration personalConfiguration);

    /**
     * 更新一条数据
     *
     * @param personalConfiguration 实体类
     * @return
     */
    Boolean updateData(PersonalConfiguration personalConfiguration);
}
