package com.digiwin.mobile.mobileuibot.mapper.db2;

import com.digiwin.mobile.mobileuibot.mapper.base.MobileBaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.mobile.mobileuibot.dto.AppClientPageDto;
import com.digiwin.mobile.mobileuibot.dto.AppClientVo;
import com.digiwin.mobile.mobileuibot.model.db2.AppClient;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * <p>功能描述：客户端版本配置 Mapper</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppClientMapper.java
 * @Author: wangjwc
 * @Date: created at 2025/6/26 18:03
 */
@Mapper
public interface AppClientMapper extends MobileBaseMapper<AppClient> {
    /**
     * 列表分页查询
     *
     * @param page 分页
     * @param query 查询参数
     * @return 分页结果
     */
    Page<AppClientVo> listPage(@Param("page") Page<AppClientVo> page, @Param("query") AppClientPageDto query);

    /**
     * 根据ID查询
     *
     * @param id ID
     * @return 结果
     */
    AppClientVo queryById(@Param("id") Long id);
}