package com.digiwin.mobile.mobileuibot.model.db1;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;


import java.io.Serializable;
import java.util.Date;

@TableName("esp_callback_info")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CallbackInfo implements Serializable {

    private static final long serialVersionUID = -995194781211637168L;
    /**
     * 记录id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 请求ID
     */
    @TableField("req_id")
    private String reqId;
    /**
     * 回调数据
     */
    @TableField("callback_data")
    private String callbackData;
    /**
     * 回调状态
     */
    @TableField("status")
    private String status; // 状态（pending/completed）

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField("create_time")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField("update_time")
    private Date updateTime;

}
