package com.digiwin.mobile.mobileuibot.model.db1;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 功能: 文件上传记录
 *
 * @author: wjw
 * @date: created at 2023/2/16
 */
@Data
@Accessors(chain = true)
@TableName("file_upload_record")
public class FileUploadRecord implements Serializable {
    private static final long serialVersionUID = 3407303644603241477L;
    /**
     * 记录id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 用户名称
     */
    private String userName;
    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * app包名
     */
    private String appPackageName;
    /**
     * 上传位置，可选值：dmc、local；dmc表示中间件存储，local表示本地存储
     */
    private String uploadLocation;
    /**
     * 文件夹名称
     */
    private String dirName;
    /**
     * 文件上传后的id
     */
    private String fileId;
    /**
     * 文件名称
     */
    private String fileName;
    /**
     * 原始文件名称
     */
    private String originalFileName;
    /**
     * 文件地址
     */
    private String fileUrl;
    /**
     * 文件大小
     */
    private Long fileSize;
    /**
     * 上传时间
     */
    private Date uploadTime;
    /**
     * app版本号
     */
    private String appVersion;
    /**
     * app设备型号
     */
    private String appDeviceType;
}