package com.digiwin.mobile.mobileuibot.model.db1;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>功能描述： 全局资讯看板实体类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: InformationBoard.java
 * @Author: wangjwc
 * @Date: created at 2024/11/11 18:33
 */
@Data
@Accessors(chain = true)
@TableName("information_board")
public class InformationBoard implements Serializable {
    private static final long serialVersionUID = 6595429394128657235L;
    /**
     * 看板ID
     */
    @TableId
    private String boardId;
    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * 用户ID
     */
    private String userId;
    /**
     * 看板名称
     */
    private String boardName;
    /**
     * 看板内容-数组
     */
    private String boardContent;
    /**
     * 删除标志 0：未删除  1：已删除
     */
    private Integer delFlag;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
}