package com.digiwin.mobile.mobileuibot.model.db1;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;

/**
 * 表名：language_source
 */
@TableName("language_source")
public class LanguageSource implements Serializable {
    private static final long serialVersionUID = 6060205084648981970L;
    @TableId(type = IdType.AUTO)
    @TableField("source_id")
    private Long sourceId;

    private String phrase;

    /**
     * 语言别
     */
    private String locale;

    /**
     * 对应语言别的文字内容
     */
    @TableField("source_value")
    private String sourceValue;


    public LanguageSource() {
    }

    public LanguageSource(String phrase, String locale, String sourceValue) {
        this.phrase = phrase;
        this.locale = locale;
        this.sourceValue = sourceValue;
    }

    /**
     * @return sourceId
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * @param sourceId
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    /**
     * @return phrase
     */
    public String getPhrase() {
        return phrase;
    }

    /**
     * @param phrase
     */
    public void setPhrase(String phrase) {
        this.phrase = phrase == null ? null : phrase.trim();
    }

    /**
     * 获取语言别
     *
     * @return locale - 语言别
     */
    public String getLocale() {
        return locale;
    }

    /**
     * 设置语言别
     *
     * @param locale 语言别
     */
    public void setLocale(String locale) {
        this.locale = locale == null ? null : locale.trim();
    }

    /**
     * 获取对应语言别的文字内容
     *
     * @return sourceValue - 对应语言别的文字内容
     */
    public String getSourceValue() {
        return sourceValue;
    }

    /**
     * 设置对应语言别的文字内容
     *
     * @param sourceValue 对应语言别的文字内容
     */
    public void setSourceValue(String sourceValue) {
        this.sourceValue = sourceValue == null ? null : sourceValue.trim();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", sourceId=").append(sourceId);
        sb.append(", phrase=").append(phrase);
        sb.append(", locale=").append(locale);
        sb.append(", sourceValue=").append(sourceValue);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}