package com.digiwin.mobile.mobileuibot.model.db1;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Map;

/**
 * 记录外部请求
 *
 * @author zhangjj
 * @date 2022/4/28 16:05
 */
@Data
@Accessors(chain = true)
@TableName("outer_request_record")
public class OuterRequestRecord implements Serializable {
    private static final long serialVersionUID = 1404169168383637928L;
    /**
     * 请求id
     */
    @TableId
    private String requestId;
    /**
     * 请求所属链路id
     */
    private String traceId;
    /**
     * 请求方式：GET、POST、ESP...
     */
    private String method;
    /**
     * 请求来源。
     * 内部(inner)：指app端与当前服务端的请求
     * 外部(outer)：指当前服务端与外部API的请求
     */
    private String source;
    /**
     * 请求url或api名称
     */
    private String url;
    /**
     * 请求数据
     */
    private String request;
    @TableField(exist = false)
    private Request requestObj;
    /**
     * 响应数据
     */
    private String response;
    @TableField(exist = false)
    private Response responseObj;
    /**
     * 请求时间
     */
    private Timestamp requestTime;
    /**
     * 响应时间
     */
    private Timestamp responseTime;
    /**
     * 响应code
     */
    private Integer code;
    /**
     * 请求耗时
     */
    private Long millis;

    public String getRequest() {
        return JsonUtil.javaObjectToJsonString(this.requestObj);
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getResponse() {
        return JsonUtil.javaObjectToJsonString(this.responseObj);
    }

    public void setResponse(String response) {
        this.response = response;
    }

    @Data
    @Accessors(chain = true)
    public static
    class Request {
        private Map<String, Object> header;
        private String queryString;
        private Object body;
    }

    @Data
    @Accessors(chain = true)
    public static
    class Response {
        private Map<String, Object> header;
        private Object body;
    }

}
