package com.digiwin.mobile.mobileuibot.model.db1;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName("personal_configuration")
public class PersonalConfiguration {

    /**
     * 主键Id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 账号Id
     */
    private String userId;
    /**
     * 租户Id
     */
    private String tenantId;
    /**
     * 是否显示已完成-行事历用
     */
    private Boolean showCompleted;

    /**
     * 是否显示所属工厂-行事历用
     */
    private Boolean showFactory;

    /**
     * 是否显示运营单元-任务卡用
     */
    private Boolean showEoc;

    /**
     * 是否显示已处理-任务卡用
     */
    private Boolean showHandledCard;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
}
