package com.digiwin.mobile.mobileuibot.model.db1;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 推送记录日志
 * 表名：push_log
 */
@TableName("push_log")
@Data
public class PushLog implements Serializable {
    private static final long serialVersionUID = 5463246528684723847L;
    /**
     * 记录id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 用户id
     */
    @TableField("user_id")
    private String userId;

    /**
     * 别名
     */
    private String alias;

    /**
     * 操作类型
     * 可选值：
     * bind_request：绑定请求；
     * bind_response：绑定响应；
     * unbind_request：解绑请求；
     * unbind_response：解绑响应；
     * bind_request_retry：绑定重试请求；
     * bind_request_overrun：绑定重试超限请求
     */
    private String type;

    /**
     * 操作结果；0:成功；-1:失败
     */
    private String result;

    /**
     * 操作时间
     */
    private Date time;

    /**
     * app版本号
     */
    private String version;

    /**
     * 设备id
     */
    @TableField("client_id")
    private String clientId;

    /**
     * 设备型号
     */
    @TableField("device_type")
    private String deviceType;

    /**
     * 详细信息
     */
    private String msg;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", userId=").append(userId);
        sb.append(", alias=").append(alias);
        sb.append(", type=").append(type);
        sb.append(", result=").append(result);
        sb.append(", time=").append(time);
        sb.append(", version=").append(version);
        sb.append(", clientId=").append(clientId);
        sb.append(", deviceType=").append(deviceType);
        sb.append(", msg=").append(msg);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}