package com.digiwin.mobile.mobileuibot.model.db1;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户cardList筛选记录表
 * 表名：user_card_list_filter
 *
 * @author yanfeng
 * @Data 2024/04/20
 */
@TableName("user_card_list_filter")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserCardListFilter implements Serializable {
    private static final long serialVersionUID = 5463246528684723847L;
    /**
     * 记录id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 用户id
     */
    @TableField("user_id")
    private String userId;
    /**
     * 租户id
     */
    @TableField("tenant_id")
    private String tenantId;
    /**
     * 页面id
     */
    @TableField("page_id")
    private String pageId;
    /**
     * cardList页面唯一标识
     */
    @TableField("component_id")
    private String componentId;
    /**
     * 关卡ID
     */
    @TableField("tm_activity_id")
    private String tmActivityId;
    /**
     * 数据Id
     */
    @TableField("data_id")
    private String dataId;
    /**
     * 筛选内容
     */
    @TableField("data")
    private String data;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField("create_time")
    private Date createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField("update_time")
    private Date updateTime;
}