package com.digiwin.mobile.mobileuibot.model.db2;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.mobile.mobileuibot.model.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>功能描述：版更条件条件项配置表</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppConditionItem.java
 * @Author: wangjwc
 * @Date: created at 2025/6/26 17:37
 */
@Data
@Accessors(chain = true)
@TableName("app_condition_item")
public class AppConditionItem extends BaseModel {
    private static final long serialVersionUID = -6434387156486428452L;
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 条件ID（关联app_condition.id）
     */
    private Long appConditionId;
    /**
     * schema--需要与端上约定（与入参一致）
     * 关键字处理
     */
    @TableField("`schema`")
    private String schema;
    /**
     * 名称
     */
    private String name;
    /**
     * 条件符：0不显示，1显示
     */
    private Integer symbol;
    /**
     * 条件值组件：0单行文本，1多行文本，2下拉单选，3下拉多选，4租户选择框
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.ComponentEnum
     */
    private Integer component;
    /**
     * 条件值，component=2/3
     * ConditionItemSelectContent
     *  {
     *         "options": [
     *                   {
     *                     "id": "android",
     *                     "text": "Android"
     *                   },
     *                   {
     *                     "id": "ios",
     *                     "text": "iOS"
     *                   }
     *             ]
     * }
     */
    private String content;
    /**
     * 条件值校验，component=0/1
     * ConditionItemTextVerify
     * {
     *         "msg": "" , // 文案
     *         "script": "" // 效验脚本
     * }
     */
    private String verify;
    /**
     * 删除标志 0：未删除  1：已删除
     * @see com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum
     */
    private Integer delFlag;
}