package com.digiwin.mobile.mobileuibot.model.db2;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.mobile.mobileuibot.model.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>功能描述：客户端应用配置表</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppConfig.java
 * @Author: wangjwc
 * @Date: created at 2025/6/26 17:37
 */
@Data
@Accessors(chain = true)
@TableName("app_config")
public class AppConfig extends BaseModel {
    private static final long serialVersionUID = 1111250690579460476L;
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 应用code-appid
     */
    private String code;
    /**
     * 应用名称
     */
    private String name;
    /**
     * 系统类型：android,ios
     */
    private String osType;
    /**
     * 环境：华为正式区、微软测试区、微软正式区、华为测试区
     */
    private String env;
    /**
     * 应用描述
     */
    private String descr;
    /**
     * 是否有效 0：无效  1：有效
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.ValidEnum
     */
    private Integer valid;
    /**
     * 删除标志 0：未删除  1：已删除
     * @see com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum
     */
    private Integer delFlag;
}