package com.digiwin.mobile.mobileuibot.model.db2;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.mobile.mobileuibot.model.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>功能描述：客户端版本更新配置表</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppUpdate.java
 * @Author: wangjwc
 * @Date: created at 2025/6/26 17:37
 */
@Data
@Accessors(chain = true)
@TableName("app_update")
public class AppUpdate extends BaseModel {
    private static final long serialVersionUID = 611867662797990711L;
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 客户端ID（关联app_client.id）
     */
    private Long appClientId;
    /**
     * 发布类型 0：局部发布，1：全量发布
     * 注意：局部发布下(条件必须配置），满足条件提示更新（强更/提示），不满足条件的一律不提示。
     * 全量发布下（未开启强更条件不可配置），开启强更，无条件全部强更，有条件不满足条件提示更新；关闭强更，没有条件都提示更新。
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.ReleaseTypeEnum
     */
    private Integer releaseType;
    /**
     * 强制版更 0：否，1：是
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.StrongUpdateEnum
     */
    private Integer strongUpdate;
    /**
     * 强制版更范围 0：全量，1：局部。
     * 注意：type=1&&strong_update=1有值
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.UpdateRangeEnum
     */
    private Integer updateRange;
    /**
     * 下发条件配置
     */
    private String conditions;
    /**
     * 历史记录：0否，1是
     * 注意：历史下发条件记录，，根据ID降序排序可查看历史下发条件
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.BakFlagEnum
     */
    private Integer bakFlag;
    /**
     * 删除标志 0：未删除  1：已删除
     * @see com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum
     */
    private Integer delFlag;
}