/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.http;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.http.DigiwinHttpReqMsgInterceptor;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.log.TraceIdUtil;
import com.digiwin.mobile.mobileuibot.common.logrecord.OuterRequestRecordManage;
import com.digiwin.mobile.mobileuibot.common.logrecord.RequestSourceEnum;
import com.digiwin.mobile.mobileuibot.model.OuterRequestRecord;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StringUtils;

public class DigiwinHttpReqMsgInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DigiwinHttpReqMsgInterceptor.class);
    @Autowired
    private OuterRequestRecordManage outerRequestRecordManage;
    private static final int RECORD_RESPONSE_BODY_STRING_MAX_SIZE = 65536;

    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] bytes, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        int length;
        long startTime = System.currentTimeMillis();
        ClientHttpResponse response = clientHttpRequestExecution.execute(httpRequest, bytes);
        long endTime = System.currentTimeMillis();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] respBytes = new byte[512];
        while ((length = response.getBody().read(respBytes)) > 0) {
            outputStream.write(respBytes, 0, length);
        }
        try {
            this.buildOuterRequestRecord(httpRequest, bytes, response, outputStream, startTime, endTime);
        }
        catch (Exception e) {
            logger.error("DigiwinHttpReqMsgInterceptor-\u62e6\u622a\u8ddf\u8e2a\u65e5\u5fd7\u5f02\u5e38-intercept\uff1a", (Throwable)e);
        }
        if (logger.isInfoEnabled()) {
            this.traceReqAndResp(httpRequest, bytes, response, outputStream);
        }
        return new ClientHttpResponseWrapper(this, response, outputStream.toByteArray());
    }

    private void buildOuterRequestRecord(HttpRequest request, byte[] bytes, ClientHttpResponse response, ByteArrayOutputStream outputStream, long startTime, long endTime) throws IOException {
        String outerRequestUrl = request.getURI().toString();
        boolean needTruncateRespBody = outerRequestUrl.toLowerCase().contains("atdm");
        OuterRequestRecord.Request requestObj = this.buildRequest(request, bytes);
        OuterRequestRecord.Response responseObj = this.buildResponse(response, outputStream, needTruncateRespBody);
        OuterRequestRecord requestRecord = new OuterRequestRecord().setRequestId(UUIDUtil.getUuid()).setTraceId(TraceIdUtil.get()).setMethod(Optional.ofNullable(request.getMethod()).map(Enum::name).orElse("")).setSource(RequestSourceEnum.OUTER.getSource()).setUrl(outerRequestUrl).setRequestObj(requestObj).setResponseObj(responseObj).setRequestTime(new Timestamp(startTime)).setResponseTime(new Timestamp(endTime)).setCode(Integer.valueOf(response.getStatusCode().value())).setMillis(Long.valueOf(endTime - startTime));
        this.outerRequestRecordManage.add(requestRecord);
    }

    private OuterRequestRecord.Request buildRequest(HttpRequest request, byte[] reqBody) {
        Object body;
        String bodyStr = new String(reqBody, StandardCharsets.UTF_8);
        try {
            body = StringUtils.hasLength((String)bodyStr) ? JsonUtil.jsonStringToObject((String)bodyStr, Object.class) : new HashMap();
        }
        catch (Exception e) {
            logger.error("DigiwinHttpReqMsgInterceptor request parse error:", (Throwable)e);
            body = bodyStr;
        }
        OuterRequestRecord.Request reqRecord = new OuterRequestRecord.Request();
        reqRecord.setHeader(this.headersToMap(request.getHeaders())).setQueryString(request.getURI().getRawQuery()).setBody(body);
        return reqRecord;
    }

    private OuterRequestRecord.Response buildResponse(ClientHttpResponse response, ByteArrayOutputStream outputStream, boolean needTruncateBody) {
        Object body;
        String bodyStr = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
        try {
            body = StringUtils.hasLength((String)bodyStr) ? (needTruncateBody && bodyStr.length() > 65536 ? bodyStr.substring(0, 65536).concat("\u2026\u2026") : JsonUtil.jsonStringToObject((String)bodyStr, Object.class)) : Collections.emptyMap();
        }
        catch (Exception e) {
            logger.error("DigiwinHttpReqMsgInterceptor response parse error:", (Throwable)e);
            if (StringUtils.hasLength((String)bodyStr)) {
                body = needTruncateBody && bodyStr.length() > 65536 ? bodyStr.substring(0, 65536).concat("\u2026\u2026") : bodyStr;
            }
            body = "";
        }
        OuterRequestRecord.Response respRecord = new OuterRequestRecord.Response();
        respRecord.setHeader(this.headersToMap(response.getHeaders())).setBody(body);
        return respRecord;
    }

    private Map<String, Object> headersToMap(HttpHeaders httpHeaders) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        if (null == httpHeaders) {
            return headers;
        }
        httpHeaders.forEach((key, values) -> headers.put((String)key, String.join((CharSequence)", ", values)));
        return headers;
    }

    private void traceReqAndResp(HttpRequest request, byte[] reqBody, ClientHttpResponse response, ByteArrayOutputStream respOutputStream) throws IOException {
        logger.info("\n===========================\u5916\u90e8HTTP\u8bf7\u6c42============================\nURI         : {}\nMethod      : {}\nHeaders     : {}\nRequest body: {}\n==========================\u5916\u90e8HTTP\u54cd\u5e94============================\nStatus code  : {}\nStatus text  : {}\nHeaders      : {}\nResponse body: {}\n", new Object[]{request.getURI(), request.getMethod(), request.getHeaders(), new String(reqBody, StandardCharsets.UTF_8), response.getStatusCode(), response.getStatusText(), response.getHeaders(), new String(respOutputStream.toByteArray(), StandardCharsets.UTF_8)});
    }
}

