/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.localization;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.localization.LocalekeyPrefixEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public final class LocaleUtil {
    private static LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleServiceImpl.class);
    private static final List<String> PREFIXES = Arrays.asList(LocalekeyPrefixEnum.DJ_MOBILE_KEY.getValue(), LocalekeyPrefixEnum.DJ_KEY.getValue());

    public static String getMobileTextByKey(String locale, String key) {
        if (key == null || key.trim().isEmpty()) {
            return "";
        }
        if (key.startsWith(LocalekeyPrefixEnum.I18N_DJ_MOBILE_KEY.getValue())) {
            key = key.substring(LocalekeyPrefixEnum.I18N_DJ_MOBILE_KEY.getValue().length(), key.length() - 1);
        }
        key = key.replace(LocalekeyPrefixEnum.DJ_MOBILE_KEY.getValue(), "").replace(LocalekeyPrefixEnum.DJ_KEY.getValue(), "").replace("mobile-", "");
        Map resource = (Map)AppContext.getDefaultI18nResourceMap().get(locale);
        for (String prefix : PREFIXES) {
            String textValue;
            String i18nKey = prefix + key;
            Map resourceZh = (Map)AppContext.getDefaultI18nResourceMap().get(Locale.SIMPLIFIED_CHINESE.toString());
            if (resourceZh == null || (textValue = (String)resourceZh.get(i18nKey)) == null) continue;
            String newValue = textValue;
            if (resource != null && (textValue = (String)resource.get(i18nKey)) != null) {
                return textValue;
            }
            return localeService.getLanguageValue(locale, newValue);
        }
        return localeService.getLanguageValue(locale, key);
    }

    public static String getMobileTextByDatabaseKey(String locale, String databaseKey) {
        return LocaleUtil.getMobileTextByKey((String)locale, (String)databaseKey);
    }

    public static String getMobileTextWithUnit(String locale, String prefix, String amount, String unit, boolean isCurrencyUnit, String suffix) {
        if (locale.equals(Locale.US.toString())) {
            int amountInt = Integer.parseInt(amount);
            String newUnit = amountInt > 1 && !isCurrencyUnit ? unit + "s" : unit;
            String newPrefix = !prefix.trim().isEmpty() ? prefix + " " : prefix;
            String newSuffix = !suffix.trim().isEmpty() ? " " + suffix : suffix;
            return newPrefix + amount + " " + newUnit + newSuffix;
        }
        return prefix + amount + unit + suffix;
    }

    public static String getPhrasedMobileText(String locale, String prefix, String fieldShowName, String suffix) {
        if (locale.equals(Locale.US.toString())) {
            return prefix + " " + fieldShowName + " " + suffix;
        }
        return prefix + fieldShowName + suffix;
    }
}

