/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.logrecord;

import com.digiwin.mobile.mobileuibot.config.request.mock.MockInterceptor;
import com.digiwin.mobile.mobileuibot.config.request.mock.OuterMockData;
import com.digiwin.mobile.mobileuibot.model.OuterRequestRecord;
import com.digiwin.mobile.mobileuibot.mysql.service.OuterRequestRecordService;
import com.digiwin.mobile.mobileuibot.proxy.experience.service.DigiwinExperienceProxyService;
import java.util.ArrayList;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OuterRequestRecordManage {
    private static final Logger logger = LoggerFactory.getLogger(OuterRequestRecordManage.class);
    private static BlockingDeque<OuterRequestRecord> BLOCKING_DEQUE = new LinkedBlockingDeque(1000);
    private static int BATCHNUM = 100;
    @Autowired
    private OuterRequestRecordService outerRequestRecordService;
    @Autowired
    private DigiwinExperienceProxyService digiwinExperienceProxyService;

    public OuterRequestRecordManage() {
        Thread thread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        this.asyncOuterRequestRecord();
                        this.asyncMockData();
                    }
                }
                catch (Exception e) {
                    logger.error("OuterRequestRecordManage Failed to save log record, error:", (Throwable)e);
                    continue;
                }
                break;
            }
        });
        thread.setName("OuterRequestRecordManage");
        thread.start();
    }

    public void add(OuterRequestRecord outerRequestRecord) {
        BLOCKING_DEQUE.offer(outerRequestRecord);
    }

    private void asyncOuterRequestRecord() {
        OuterRequestRecord record;
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            logger.error("asyncOuterRequestRecord interruptedException, error:", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("asyncOuterRequestRecord failed, error:", (Throwable)e);
        }
        OuterRequestRecord firstRecord = (OuterRequestRecord)BLOCKING_DEQUE.poll();
        if (null == firstRecord) {
            return;
        }
        ArrayList<OuterRequestRecord> recordList = new ArrayList<OuterRequestRecord>();
        recordList.add(firstRecord);
        for (int i = 1; i < BATCHNUM && null != (record = (OuterRequestRecord)BLOCKING_DEQUE.poll()); ++i) {
            recordList.add(record);
        }
        this.outerRequestRecordService.batchInsert(recordList);
    }

    private void asyncMockData() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            logger.error("asyncMockData interruptedException, error:", (Throwable)e);
        }
        catch (Exception e) {
            // empty catch block
        }
        OuterMockData outerMockData = (OuterMockData)MockInterceptor.BLOCKING_DEQUE.poll();
        if (null == outerMockData) {
            return;
        }
        this.digiwinExperienceProxyService.reportMockData(outerMockData);
    }
}

