/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.config.request;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.common.url.UrlUtil;
import com.digiwin.mobile.mobileuibot.mock.model.MockData;
import com.digiwin.mobile.mobileuibot.mock.model.MockDataRepository;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class RequestContextInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(RequestContextInterceptor.class);
    @Autowired
    private MockDataRepository mockDataRepository;
    private static final String MOCK_URI = "/mobile/v1/mock/data";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        MockData mockData;
        String requestUri = AppRequestContext.getContextEntity().getRequestUri();
        if (MOCK_URI.equalsIgnoreCase(requestUri)) {
            return true;
        }
        if (request.getContentType() != null && request.getContentType().contains("multipart/form-data;")) {
            return true;
        }
        String pageId = "";
        String dataId = "";
        String locale = "";
        String requestId = "";
        String userId = "";
        String tenantId = "";
        String iamUserToken = "";
        Map rawData = new HashMap();
        if (HttpMethod.POST.name().equalsIgnoreCase(request.getMethod())) {
            Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
            if (params.containsKey("sysParam")) {
                Map sysParam = (Map)params.get("sysParam");
                pageId = (String)sysParam.get("pageId");
                dataId = (String)sysParam.get("dataId");
                locale = (String)sysParam.get("locale");
                requestId = (String)sysParam.get("requestId");
                userId = (String)sysParam.get("userId");
                tenantId = (String)sysParam.get("tenantId");
                iamUserToken = (String)sysParam.get("iamUserToken");
            } else {
                pageId = (String)params.get("pageId");
                dataId = (String)params.get("dataId");
                locale = (String)params.get("locale");
                requestId = (String)params.get("requestId");
                userId = (String)params.get("userId");
                tenantId = (String)params.get("tenantId");
                iamUserToken = (String)params.get("iamUserToken");
                rawData = (Map)params.get("rawData");
            }
        }
        if (!StringUtils.hasLength((String)dataId)) {
            String url = requestUri + "?" + request.getQueryString();
            Map params = UrlUtil.parseUrl((String)url);
            if (params.containsKey("dataId")) {
                dataId = (String)params.get("dataId");
            }
            if (params.containsKey("userId")) {
                userId = (String)params.get("userId");
            }
            if (params.containsKey("tenantId")) {
                tenantId = (String)params.get("tenantId");
            }
            if (params.containsKey("iamUserToken")) {
                iamUserToken = (String)params.get("iamUserToken");
            }
        }
        String proxyToken = request.getHeader("proxyToken");
        if (!CollectionUtils.isEmpty(rawData)) {
            AppRequestContext.getContextEntity().setIsTeamTask(Boolean.valueOf((Boolean)MapUtil.getOrDefault(rawData, (String)"isTeamTask", (Object)false)));
            AppRequestContext.getContextEntity().setPinning(Boolean.valueOf((Boolean)MapUtil.getOrDefault(rawData, (String)"pinning", (Object)false)));
            if (rawData.containsKey("digi-proxy-token") && StringUtils.hasLength((String)((String)rawData.get("digi-proxy-token")))) {
                proxyToken = (String)rawData.get("digi-proxy-token");
            }
        }
        if (!"null".equalsIgnoreCase(proxyToken)) {
            AppRequestContext.getContextEntity().setProxyToken(proxyToken);
        }
        AppRequestContext.getContextEntity().setPageId(pageId);
        AppRequestContext.getContextEntity().setDataId(dataId);
        String modelType = request.getHeader("modelType");
        String FIXED_USER_ID = "lucxa@digiwin.com";
        String MOCK_IAMUSERTOKEN = "dabc7c4a-0912-4183-b629-382884a9e6f1";
        if (StringUtils.hasLength((String)iamUserToken) && (FIXED_USER_ID.equals(userId) || "dabc7c4a-0912-4183-b629-382884a9e6f1".equals(iamUserToken))) {
            modelType = "show";
            this.buildAppRequestContextEntity(request, true, "PURCHASING_MANAGER");
        } else {
            this.buildAppRequestContextEntity(request, false, request.getHeader("roleId"));
        }
        if ("show".equalsIgnoreCase(modelType) && (mockData = this.mockDataRepository.getMockData(requestUri, pageId, dataId, locale, requestId)) != null) {
            request.setAttribute("mockData", (Object)mockData);
            request.setAttribute("experience_real_url", (Object)requestUri);
            request.getRequestDispatcher("/mobile/v1/mock/data/" + request.getMethod().toLowerCase()).forward((ServletRequest)request, (ServletResponse)response);
            return false;
        }
        return super.preHandle(request, response, handler);
    }

    private void buildAppRequestContextEntity(HttpServletRequest request, boolean forceExperienceMode, String experienceModeRoleId) throws IOException {
        AppRequestContext.ContextEntity context = AppRequestContext.getContextEntity();
        Integer renderVersion = request.getIntHeader("renderVersion");
        context.setRenderVersion(renderVersion);
        String modelType = request.getHeader("modelType");
        if (forceExperienceMode) {
            modelType = "show";
        }
        context.setExperienceRoleId(experienceModeRoleId);
        context.setModelType(modelType);
        if (HttpMethod.GET.name().equals(request.getMethod())) {
            this.doGet(request, context);
        } else {
            this.doPost(request, context);
        }
        if (!StringUtils.hasLength((String)context.getTenantId())) {
            context.setTenantId(request.getHeader("routerKey"));
        }
        String requestURI = request.getRequestURI();
        String sanitizedUrl = requestURI.replace("\r", "").replace("\n", "");
        logger.debug("request uri:{}, ip:{}, context:{}", new Object[]{sanitizedUrl, request.getRemoteAddr(), JsonUtil.javaObjectToJsonString((Object)context)});
    }

    private void doPost(HttpServletRequest request, AppRequestContext.ContextEntity context) throws IOException {
        String tenantId = request.getParameter("tenantId");
        String locale = request.getParameter("locale");
        String userId = request.getParameter("userId");
        String iamUserToken = request.getParameter("iamUserToken");
        context.setTenantId(tenantId);
        context.setLocale(locale);
        context.setUserId(userId);
        context.setIamUserToken(iamUserToken);
        if (StringUtils.hasLength((String)tenantId) && StringUtils.hasLength((String)locale) && StringUtils.hasLength((String)userId)) {
            return;
        }
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)request.getCharacterEncoding());
        ApiRequest apiRequest = (ApiRequest)JsonUtil.objectToJavaObject((Object)params, ApiRequest.class);
        context.setTenantId(apiRequest.getTenantId());
        context.setLocale(apiRequest.getLocale());
        context.setUserId(apiRequest.getUserId());
        context.setIamUserToken(apiRequest.getIamUserToken());
    }

    private void doGet(HttpServletRequest request, AppRequestContext.ContextEntity context) {
        context.setTenantId(request.getParameter("tenantId"));
        context.setLocale(request.getParameter("locale"));
        context.setUserId(request.getParameter("userId"));
        context.setIamUserToken(request.getParameter("iamUserToken"));
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        AppRequestContext.remove();
        super.afterCompletion(request, response, handler, ex);
    }
}

