/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.config.request.log;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.log.TraceIdUtil;
import com.digiwin.mobile.mobileuibot.common.logrecord.OuterRequestRecordManage;
import com.digiwin.mobile.mobileuibot.common.logrecord.RequestSourceEnum;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.config.request.RequestWrapper;
import com.digiwin.mobile.mobileuibot.model.OuterRequestRecord;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class RequestResponseLogInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(RequestResponseLogInterceptor.class);
    public static final String RESPONSE_BODY = "response_body";
    private static final TransmittableThreadLocal<OuterRequestRecord> OUTER_REQUEST_RECORD = new TransmittableThreadLocal();
    @Autowired
    private OuterRequestRecordManage outerRequestRecordManage;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            String requestUri = request.getRequestURI().replaceAll("//", "/");
            AppRequestContext.getContextEntity().setRequestUri(requestUri);
            RequestWrapper requestWrapper = new RequestWrapper(request);
            this.buildOuterRequestRecordOfRequest(requestWrapper);
            String requestURI = request.getRequestURI();
            String sanitizedUrl = requestURI.replace("\r", "").replace("\n", "");
            logger.debug("----------------\u5185\u90e8HTTP\u8bf7\u6c42----------------\nCurrentTime: {}\nRequestURI: {}\nMethod: {}\nRequestHeaders: {}\nQueryString: {}\nRequestBody: {}\nController & Method: {}\n-------------------------End-------------------------", new Object[]{DateTimeUtil.getTodayTimeUseDefaultPattern(), sanitizedUrl, request.getMethod(), JsonUtil.javaObjectToJsonString((Object)this.getRequestHeaderNamesAndValues(request)), request.getQueryString(), requestWrapper.getBodyString(), handler});
        }
        catch (Exception e) {
            logger.error("MVC\u4e1a\u52a1\u5904\u7406-\u62e6\u622a\u5668\u5f02\u5e38-preHandle\uff1a", (Throwable)e);
        }
        return true;
    }

    private void buildOuterRequestRecordOfRequest(RequestWrapper requestWrapper) throws IOException {
        OUTER_REQUEST_RECORD.set((Object)new OuterRequestRecord().setRequestId(UUIDUtil.getUuid()).setMethod(requestWrapper.getMethod()).setSource(RequestSourceEnum.INNER.getSource()).setUrl(requestWrapper.getRequestURL().toString()).setRequestObj(this.buildRequest(requestWrapper)).setRequestTime(new Timestamp(System.currentTimeMillis())));
    }

    private OuterRequestRecord.Request buildRequest(RequestWrapper request) throws IOException {
        OuterRequestRecord.Request reqRecord = new OuterRequestRecord.Request();
        reqRecord.setHeader(this.getRequestHeaderNamesAndValues((HttpServletRequest)request)).setQueryString(request.getQueryString());
        if (HttpMethod.POST.name().equals(request.getMethod())) {
            Map body = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)request.getCharacterEncoding());
            reqRecord.setBody((Object)body);
        }
        return reqRecord;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (StringUtils.hasLength((String)TraceIdUtil.get())) {
            long startTime = Long.parseLong(TraceIdUtil.getTraceStartTime());
            long endTime = System.currentTimeMillis();
            logger.debug("========================HTTP\u8bf7\u6c42\u5904\u7406\u5b8c\u6210==========================\nresponseTime\uff1a{}\nrunningTime\uff1a{}ms", (Object)DateTimeUtil.getTodayTimeUseDefaultPattern(), (Object)(endTime - startTime));
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        try {
            this.buildOuterRequestRecordOfResponse(request, response);
        }
        catch (Exception e) {
            logger.error("MVC\u4e1a\u52a1\u5904\u7406-\u62e6\u622a\u5668\u5f02\u5e38-afterCompletion\uff1a", (Throwable)e);
        }
        OUTER_REQUEST_RECORD.remove();
    }

    private void buildOuterRequestRecordOfResponse(HttpServletRequest request, HttpServletResponse response) {
        Object responseBody = request.getAttribute(RESPONSE_BODY);
        OuterRequestRecord requestRecord = (OuterRequestRecord)OUTER_REQUEST_RECORD.get();
        if (null == requestRecord) {
            return;
        }
        Timestamp responseTime = new Timestamp(System.currentTimeMillis());
        requestRecord.setResponseObj(this.buildResponse(responseBody, response)).setTraceId(TraceIdUtil.get()).setResponseTime(responseTime).setCode(Integer.valueOf(responseBody == null ? 500 : Integer.parseInt(((ApiResponse)responseBody).getCode()))).setMillis(Long.valueOf(responseTime.getTime() - requestRecord.getRequestTime().getTime()));
        this.outerRequestRecordManage.add(requestRecord);
    }

    private OuterRequestRecord.Response buildResponse(Object responseBody, HttpServletResponse response) {
        Map body = new HashMap();
        if (null != responseBody) {
            ApiResponse apiResponse = (ApiResponse)responseBody;
            body = (Map)JsonUtil.objectToJavaObject((Object)apiResponse, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        OuterRequestRecord.Response respRecord = new OuterRequestRecord.Response();
        respRecord.setHeader(this.getResponseHeaderNamesAndValues(response)).setBody(body);
        return respRecord;
    }

    private Map<String, Object> getRequestHeaderNamesAndValues(HttpServletRequest request) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            headers.put(headerName, headerValue);
        }
        return headers;
    }

    private Map<String, Object> getResponseHeaderNamesAndValues(HttpServletResponse response) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        response.getHeaderNames().forEach(headerName -> headers.put((String)headerName, response.getHeader(headerName)));
        return headers;
    }
}

