/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.business.pcc;

import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignEnum;
import com.digiwin.mobile.mobileuibot.core.component.business.DetailPage;
import com.digiwin.mobile.mobileuibot.core.component.business.pcc.PccStringUtil;
import com.digiwin.mobile.mobileuibot.core.component.business.pcc.PccTailTaskProductItemDataItemTitle;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class PccTailTaskProductItemDataItem
implements Serializable {
    private static final long serialVersionUID = 7500260871654689688L;
    public static final String COMPONENT_TYPE = "PCC_TAIL_TASK_PRODUCT_ITEM_DATA_ITEM";
    private static String[] taskCategoryArray = new String[]{"ORD", "PLM", "PLM_PROJECT", "MES,REVIEW", "POSUM", "1", "2", "3", "4"};
    private List<Field> content = new ArrayList(5);
    private DetailPage detailPage;
    private Integer openType;
    private PccTailTaskProductItemDataItemTitle title;

    private PccTailTaskProductItemDataItem() {
    }

    public static PccTailTaskProductItemDataItem create(ApiRequest apiRequest, Map<String, Object> pccTailData, PccProjectTaskInfo taskInfo, String taskCategory) {
        PccTailTaskProductItemDataItem dataItem;
        String locale = apiRequest.getLocale();
        String dataId = apiRequest.getDataId();
        ApiExtraParameter newApiExtraParameter = new ApiExtraParameter();
        newApiExtraParameter.setForItemDetail(Boolean.valueOf(true));
        ApiRawData newApiRawData = new ApiRawData();
        newApiRawData.put("taskInfo", (Object)taskInfo);
        newApiRawData.put("productItem", pccTailData);
        switch (taskCategory.toUpperCase()) {
            case "ORD": {
                dataItem = PccTailTaskProductItemDataItem.createOrdCategoryItem((ApiRequest)apiRequest, pccTailData, (PccProjectTaskInfo)taskInfo);
                break;
            }
            case "PLM": {
                dataItem = PccTailTaskProductItemDataItem.createPlmCategoryItem((ApiRequest)apiRequest, pccTailData, (PccProjectTaskInfo)taskInfo);
                break;
            }
            case "PLM_PROJECT": {
                dataItem = PccTailTaskProductItemDataItem.createPlmProjectCategoryItem((ApiRequest)apiRequest, pccTailData, (PccProjectTaskInfo)taskInfo);
                break;
            }
            case "MES": {
                dataItem = PccTailTaskProductItemDataItem.createMesCategoryItem((ApiRequest)apiRequest, pccTailData, (PccProjectTaskInfo)taskInfo);
                break;
            }
            case "REVIEW": {
                dataItem = PccTailTaskProductItemDataItem.createReviewCategoryItem((ApiRequest)apiRequest, pccTailData, (PccProjectTaskInfo)taskInfo);
                break;
            }
            case "POSUM": {
                dataItem = PccTailTaskProductItemDataItem.createPosumCategoryItem((ApiRequest)apiRequest, pccTailData, (PccProjectTaskInfo)taskInfo);
                break;
            }
            default: {
                dataItem = PccTailTaskProductItemDataItem.createOtherCategoryItem((ApiRequest)apiRequest, pccTailData, (PccProjectTaskInfo)taskInfo, (boolean)false);
            }
        }
        dataItem.setOpenType(Integer.valueOf(1));
        dataItem.setDetailPage(DetailPage.create((String)locale, (String)dataId, (ApiExtraParameter)newApiExtraParameter, (String)PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_MATERIAL_DETAIL.toString(), (ApiRawData)newApiRawData));
        return dataItem;
    }

    public static PccTailTaskProductItemDataItem createKsc(ApiRequest apiRequest, Map<String, Object> pccTailData, PccProjectTaskInfo taskInfo, String taskCategory) {
        PccTailTaskProductItemDataItem dataItem;
        String locale = apiRequest.getLocale();
        String dataId = apiRequest.getDataId();
        ApiExtraParameter newApiExtraParameter = new ApiExtraParameter();
        newApiExtraParameter.setForItemDetail(Boolean.valueOf(true));
        ApiRawData newApiRawData = new ApiRawData();
        newApiRawData.put("taskInfo", (Object)taskInfo);
        newApiRawData.put("productItem", pccTailData);
        switch (taskCategory.toUpperCase()) {
            case "ORD": 
            case "1": 
            case "2": 
            case "3": 
            case "4": {
                dataItem = PccTailTaskProductItemDataItem.createOrdCategoryItem((ApiRequest)apiRequest, pccTailData, (PccProjectTaskInfo)taskInfo);
                break;
            }
            case "PLM": {
                dataItem = PccTailTaskProductItemDataItem.createPlmCategoryItem((ApiRequest)apiRequest, pccTailData, (PccProjectTaskInfo)taskInfo);
                break;
            }
            case "PLM_PROJECT": {
                dataItem = PccTailTaskProductItemDataItem.createPlmProjectCategoryItem((ApiRequest)apiRequest, pccTailData, (PccProjectTaskInfo)taskInfo);
                break;
            }
            case "MES": {
                dataItem = PccTailTaskProductItemDataItem.createMesCategoryItem((ApiRequest)apiRequest, pccTailData, (PccProjectTaskInfo)taskInfo);
                break;
            }
            case "REVIEW": {
                dataItem = PccTailTaskProductItemDataItem.createReviewCategoryItem((ApiRequest)apiRequest, pccTailData, (PccProjectTaskInfo)taskInfo);
                break;
            }
            case "POSUM": {
                dataItem = PccTailTaskProductItemDataItem.createPosumCategoryItem((ApiRequest)apiRequest, pccTailData, (PccProjectTaskInfo)taskInfo);
                break;
            }
            default: {
                dataItem = PccTailTaskProductItemDataItem.createOtherCategoryItem((ApiRequest)apiRequest, pccTailData, (PccProjectTaskInfo)taskInfo, (boolean)true);
            }
        }
        dataItem.setOpenType(Integer.valueOf(1));
        dataItem.setDetailPage(DetailPage.create((String)locale, (String)dataId, (ApiExtraParameter)newApiExtraParameter, (String)PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_MATERIAL_DETAIL.toString(), (ApiRawData)newApiRawData));
        return dataItem;
    }

    private static PccTailTaskProductItemDataItem createOrdCategoryItem(ApiRequest apiRequest, Map<String, Object> pccTailData, PccProjectTaskInfo taskInfo) {
        String[] leftTitleFields = new String[]{"liable_person_name"};
        String rightTitleField = "";
        String[] contentFields = new String[]{"plan_start_date", "plan_finish_date", "actual_start_date", "remarks", "work_hours", "complete_rate", "actual_finish_date", "total_work_hours", "attachment_remark", "remark", "is_approve", "attachment"};
        int contentFieldsLimit = 4;
        return PccTailTaskProductItemDataItem.baseCreateItem((String)apiRequest.getLocale(), (PccProjectTaskInfo)taskInfo, pccTailData, (String[])leftTitleFields, (String)rightTitleField, (String[])contentFields, (int)4);
    }

    private static PccTailTaskProductItemDataItem createPlmCategoryItem(ApiRequest apiRequest, Map<String, Object> pccTailData, PccProjectTaskInfo taskInfo) {
        String[] leftTitleFields = new String[]{"design_status"};
        String rightTitleField = "";
        String[] contentFields = new String[]{"project_no", "task_no", "complete_rate", "remark", "design_no", "design_name", "report_work_description", "actual_start_date", "actual_finish_date"};
        int contentFieldsLimit = 4;
        return PccTailTaskProductItemDataItem.baseCreateItem((String)apiRequest.getLocale(), (PccProjectTaskInfo)taskInfo, pccTailData, (String[])leftTitleFields, (String)rightTitleField, (String[])contentFields, (int)4);
    }

    private static PccTailTaskProductItemDataItem createPlmProjectCategoryItem(ApiRequest apiRequest, Map<String, Object> pccTailData, PccProjectTaskInfo taskInfo) {
        String[] leftTitleFields = new String[]{"task_status"};
        String rightTitleField = "";
        String[] contentFields = new String[]{"task_name", "task_complete_rate", "is_on_schedule", "important", "actual_start_date", "actual_finish_date", "project_no", "task_no", "task_seq", "upper_level_task_no", "before_task_no", "milestone_type", "plan_work_days", "plan_work_hours", "plan_start_date", "plan_finish_date", "executor_name", "executor_role"};
        int contentFieldsLimit = 4;
        return PccTailTaskProductItemDataItem.baseCreateItem((String)apiRequest.getLocale(), (PccProjectTaskInfo)taskInfo, pccTailData, (String[])leftTitleFields, (String)rightTitleField, (String[])contentFields, (int)4);
    }

    private static PccTailTaskProductItemDataItem createMesCategoryItem(ApiRequest apiRequest, Map<String, Object> pccTailData, PccProjectTaskInfo taskInfo) {
        String[] leftTitleFields = new String[]{"status"};
        String rightTitleField = "";
        String[] contentFields = new String[]{"wo_no", "item_no", "item_name_spec", "machine_no", "production_qty", "plan_date_e", "complete_rate", "work_hours", "process_seq", "op_name", "op_type", "supplier_name", "feed_qty", "complete_qty", "op_no"};
        int contentFieldsLimit = 4;
        return PccTailTaskProductItemDataItem.baseCreateItem((String)apiRequest.getLocale(), (PccProjectTaskInfo)taskInfo, pccTailData, (String[])leftTitleFields, (String)rightTitleField, (String[])contentFields, (int)4);
    }

    private static PccTailTaskProductItemDataItem createReviewCategoryItem(ApiRequest apiRequest, Map<String, Object> pccTailData, PccProjectTaskInfo taskInfo) {
        String[] leftTitleFields = new String[]{"liable_person_name"};
        String rightTitleField = "";
        String[] contentFields = new String[]{"plan_start_date", "plan_finish_date", "actual_start_date", "remarks", "work_hours", "complete_rate", "actual_finish_date", "total_work_hours", "attachment_remark", "remark", "is_approve", "attachment"};
        int contentFieldsLimit = 4;
        return PccTailTaskProductItemDataItem.baseCreateItem((String)apiRequest.getLocale(), (PccProjectTaskInfo)taskInfo, pccTailData, (String[])leftTitleFields, (String)rightTitleField, (String[])contentFields, (int)4);
    }

    private static PccTailTaskProductItemDataItem createPosumCategoryItem(ApiRequest apiRequest, Map<String, Object> pccTailData, PccProjectTaskInfo taskInfo) {
        String[] leftTitleFields = new String[]{"purchase_no"};
        String rightTitleField = "";
        String[] contentFields = new String[]{"reference_type_no", "reference_doc_no", "item_name_spec", "item_classification", "complete_rate", "purchaser_name", "purchase_qty", "stock_in_qty"};
        int contentFieldsLimit = 4;
        return PccTailTaskProductItemDataItem.baseCreateItem((String)apiRequest.getLocale(), (PccProjectTaskInfo)taskInfo, pccTailData, (String[])leftTitleFields, (String)rightTitleField, (String[])contentFields, (int)4);
    }

    private static PccTailTaskProductItemDataItem createOtherCategoryItem(ApiRequest apiRequest, Map<String, Object> pccTailData, PccProjectTaskInfo taskInfo, boolean isKsc) {
        String[] leftTitleFields = new String[]{"item_no"};
        String rightTitleField = "";
        String[] contentFields = isKsc ? new String[]{"purchaser_name", "purchase_no", "purchase_seq", "purchase_sub_seq", "item_no", "item_name_spec", "purchase_qty", "stock_in_qty", "issue_set_qty", "plan_delivery_date", "complete_rate"} : new String[]{"item_name_spec_02", "purchaser_name", "purchase_no", "purchase_qty", "status", "purchase_seq", "purchase_sub_seq", "stock_in_qty", "issue_set_qty", "plan_delivery_date", "complete_rate"};
        pccTailData.put("isKsc", isKsc);
        int contentFieldsLimit = 4;
        return PccTailTaskProductItemDataItem.baseCreateItem((String)apiRequest.getLocale(), (PccProjectTaskInfo)taskInfo, pccTailData, (String[])leftTitleFields, (String)rightTitleField, (String[])contentFields, (int)4);
    }

    private static PccTailTaskProductItemDataItem baseCreateItem(String locale, PccProjectTaskInfo taskInfo, Map<String, Object> bizData, String[] leftTitleFields, String rightTitleField, String[] contentFields, int contentFieldCreateLimit) {
        String value;
        ArrayList<String> leftTitle = new ArrayList<String>();
        ArrayList<String> rightTitle = new ArrayList<String>();
        PccTailTaskProductItemDataItem productItemDataItem = new PccTailTaskProductItemDataItem();
        int contentFieldCreatedCount = 0;
        boolean isNotOtherCategory = Arrays.stream(taskCategoryArray).anyMatch(e -> e.equalsIgnoreCase(taskInfo.getTaskCategory()));
        Boolean isKsc = (Boolean)MapUtil.getOrDefault(bizData, (String)"isKsc", (Object)false);
        for (String leftTitleField : leftTitleFields) {
            String value2 = String.valueOf(MapUtil.getOrDefault(bizData, (String)leftTitleField, (Object)""));
            if (value2.trim().isEmpty()) {
                if (isNotOtherCategory || isKsc.booleanValue()) continue;
                value2 = "-";
            }
            value2 = PccStringUtil.getValueShowText((String)locale, (String)taskInfo.getTaskCategory(), (String)leftTitleField, (String)value2);
            leftTitle.add(value2);
        }
        if (bizData.containsKey(rightTitleField) && !(value = String.valueOf(MapUtil.getOrDefault(bizData, (String)rightTitleField, (Object)""))).trim().isEmpty()) {
            value = PccStringUtil.getValueShowText((String)locale, (String)taskInfo.getTaskCategory(), (String)rightTitleField, (String)value);
            rightTitle.add(value);
        }
        productItemDataItem.setTitle(PccTailTaskProductItemDataItemTitle.create((String)locale, leftTitle, (String)(rightTitle.isEmpty() ? "" : (String)rightTitle.get(0))));
        for (String contentField : contentFields) {
            String label = LocaleUtil.getMobileTextByKey((String)locale, (String)contentField);
            String value3 = String.valueOf(MapUtil.getOrDefault(bizData, (String)contentField, (Object)""));
            if ("item_name_spec_02".equals(contentField) && !isNotOtherCategory && !isKsc.booleanValue()) {
                value3 = value3.replace("</br>", "\n");
                label = LocaleUtil.getMobileTextByKey((String)locale, (String)"item_name_spec");
            }
            if (value3.trim().isEmpty() || "attachment".equals(contentField)) {
                if (isNotOtherCategory) continue;
                value3 = "-";
            }
            value3 = PccStringUtil.getValueShowText((String)locale, (String)taskInfo.getTaskCategory(), (String)contentField, (String)value3);
            Field itemContentField = Field.create((String)label, (Integer)2, (Integer)1, (String)value3);
            itemContentField.setSchema(contentField);
            if ("remarks".equalsIgnoreCase(contentField) && value3.contains("\n")) {
                value3 = value3.replaceAll("\n", "\n\u25cf ");
                value3 = "\u25cf " + value3;
                itemContentField.setValue(value3);
                itemContentField.setAlign(Integer.valueOf(FieldAlignEnum.VERTICAL.getValue()));
            }
            productItemDataItem.getContent().add(itemContentField);
            if (++contentFieldCreatedCount == contentFieldCreateLimit) break;
        }
        return productItemDataItem;
    }

    public List<Field> getContent() {
        return this.content;
    }

    public void setContent(List<Field> content) {
        this.content = content;
    }

    public DetailPage getDetailPage() {
        return this.detailPage;
    }

    public void setDetailPage(DetailPage detailPage) {
        this.detailPage = detailPage;
    }

    public PccTailTaskProductItemDataItemTitle getTitle() {
        return this.title;
    }

    public void setTitle(PccTailTaskProductItemDataItemTitle title) {
        this.title = title;
    }

    public Integer getOpenType() {
        return this.openType;
    }

    public void setOpenType(Integer openType) {
        this.openType = openType;
    }
}

