/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.button;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonBizReportBuilder;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonRawData;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="bottomButtonBizReportBuilder")
public class BottomButtonBizReportBuilder
implements MobileComponentBuilder<BottomButtonList> {
    private static final Logger logger = LoggerFactory.getLogger(BottomButtonBizReportBuilder.class);
    public static final Map<String, String> BUTTON_MAP = new HashMap();

    public BottomButtonBizReportBuilder() {
        BUTTON_MAP.put("esp_task.info.update", "submit");
        BUTTON_MAP.put("esp_upload.personnel.attachment.info.create", "submit");
        BUTTON_MAP.put("start-new-process", "submit");
        BUTTON_MAP.put("submit-data", "submit");
        BUTTON_MAP.put("esp_uc.task.info.update", "complete_submit");
        BUTTON_MAP.put("esp_bm.pisc.task.update", "submit");
    }

    public String getMobileComponentType() {
        return "BOTTOM_BUTTON";
    }

    public BottomButtonList build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<BottomButtonList> clazz, Object ... args) {
        BottomButtonList result = new BottomButtonList();
        switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$core$pagesetting$PageSettingIdPresetEnum[PageSettingIdPresetEnum.getEnumByName((String)pageSetting.getPageId()).ordinal()]) {
            case 1: {
                result = this.buildProjectScheduleReport(apiRequest, pageSetting, pcUiBotModel, clazz, args);
                break;
            }
            case 2: {
                result = this.buildReportQianyeUc(apiRequest, pageSetting, pcUiBotModel, clazz, args);
                break;
            }
            default: {
                result = this.buildDefault(apiRequest, pageSetting, pcUiBotModel, clazz, args);
            }
        }
        return result;
    }

    public BottomButtonList buildDefault(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<BottomButtonList> clazz, Object ... args) {
        List uiBotActions = pcUiBotModel.getActions();
        if (null == uiBotActions || uiBotActions.isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        String bizDataSchema = pcUiBotModel.searchBizDataSchema();
        Object bizData = pcUiBotModel.getPageData().get((Object)bizDataSchema);
        if (bizData == null) {
            return BottomButtonList.createEmpty();
        }
        if (bizData instanceof List && ((List)bizData).isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        if (bizData instanceof Map && ((Map)bizData).isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        BottomButtonList result = new BottomButtonList();
        UiBotModel pageSettingModel = pageSetting.getPageModel();
        String bottomButtonDataSchema = pageSettingModel.getLayout().stream().filter(layout -> layout.getType().equalsIgnoreCase(this.getMobileComponentType())).findFirst().orElse(new UiBotLayout()).getSchema();
        UiBotPageData pageData = pageSettingModel.getPageData();
        JSONArray bottomButtonDataArray = (JSONArray)JSON.toJSON(pageData.get(bottomButtonDataSchema));
        for (int i = 0; i < bottomButtonDataArray.size(); ++i) {
            JSONObject bottomButtonJsonObj = bottomButtonDataArray.getJSONObject(i);
            String id = bottomButtonJsonObj.getString("id");
            Optional<UiBotAction> optPcUiBotAction = uiBotActions.stream().filter(uiBotAction -> BUTTON_MAP.containsKey(uiBotAction.getActionId())).findFirst();
            if (!optPcUiBotAction.isPresent()) continue;
            UiBotAction pcUiBotAction = optPcUiBotAction.get();
            if (!id.equalsIgnoreCase((String)BUTTON_MAP.get(pcUiBotAction.getActionId()))) continue;
            JSONObject buttonActionJsonObj = bottomButtonJsonObj.getJSONObject("action");
            Integer buttonType = buttonActionJsonObj.getInteger("type");
            BottomButtonDigiwinAthena bottomButton = BottomButtonDigiwinAthena.create((UiBotAction)pcUiBotAction, (String)bizDataSchema, (Object)bizData, null, (Action)new Action(buttonType));
            if (bottomButton.getAction().getRawData() instanceof ButtonRawData) {
                ButtonRawData buttonRawData = (ButtonRawData)bottomButton.getAction().getRawData();
                Map map = buttonRawData.getData();
                if (pcUiBotAction.getSubmitType() != null && StringUtils.isNotBlank((String)pcUiBotAction.getSubmitType().getSchema())) {
                    String schema = pcUiBotAction.getSubmitType().getSchema();
                    map.put(schema, pcUiBotModel.getPageData().get((Object)schema));
                }
            }
            result.add((Object)bottomButton);
        }
        ModuleUtils.addRefreshPageId((BottomButtonList)result, (String)"");
        return result;
    }

    public BottomButtonList buildProjectScheduleReport(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<BottomButtonList> clazz, Object ... args) {
        BottomButtonList result = new BottomButtonList();
        BottomButtonDigiwinAthena submitButton = new BottomButtonDigiwinAthena();
        submitButton.setName(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u63d0\u4ea4"));
        HashMap<String, String> rawData = new HashMap<String, String>();
        rawData.put("actionId", "aaaaaa");
        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
        buttonAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/projectScheduleReport/projectScheduleSubmin");
        buttonAction.setRawData(rawData);
        submitButton.setAction(buttonAction);
        submitButton.setType(BottomButtonStyleEnum.DETAIL_NORMAL.getValue());
        result.add((Object)submitButton);
        return result;
    }

    public BottomButtonList buildReportQianyeUc(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<BottomButtonList> clazz, Object ... args) {
        List uiBotActions = pcUiBotModel.getActions();
        if (null == uiBotActions || uiBotActions.isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        String bizDataSchema = pcUiBotModel.searchBizDataSchema();
        Object bizData = pcUiBotModel.getPageData().get((Object)bizDataSchema);
        if (bizData == null) {
            return BottomButtonList.createEmpty();
        }
        if (bizData instanceof List && ((List)bizData).isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        if (bizData instanceof Map && ((Map)bizData).isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        BottomButtonList result = new BottomButtonList();
        UiBotModel pageSettingModel = pageSetting.getPageModel();
        String bottomButtonDataSchema = pageSettingModel.getLayout().stream().filter(layout -> layout.getType().equalsIgnoreCase(this.getMobileComponentType())).findFirst().orElse(new UiBotLayout()).getSchema();
        UiBotPageData pageData = pageSettingModel.getPageData();
        JSONArray bottomButtonDataArray = (JSONArray)JSON.toJSON(pageData.get(bottomButtonDataSchema));
        if (CollectionUtils.isEmpty((Collection)bottomButtonDataArray)) {
            for (UiBotAction uiBotAction2 : uiBotActions) {
                BottomButtonDigiwinAthena bottomButton = BottomButtonDigiwinAthena.create((UiBotAction)uiBotAction2, (String)bizDataSchema, (Object)bizData, null, (Action)new Action(Integer.valueOf(3)));
                result.add((Object)bottomButton);
            }
        } else {
            for (int i = 0; i < bottomButtonDataArray.size(); ++i) {
                JSONObject bottomButtonJsonObj = bottomButtonDataArray.getJSONObject(i);
                String id = bottomButtonJsonObj.getString("id");
                Optional<UiBotAction> optPcUiBotAction = uiBotActions.stream().filter(uiBotAction -> BUTTON_MAP.containsKey(uiBotAction.getActionId())).findFirst();
                if (!optPcUiBotAction.isPresent()) continue;
                UiBotAction pcUiBotAction = optPcUiBotAction.get();
                if (!id.equalsIgnoreCase((String)BUTTON_MAP.get(pcUiBotAction.getActionId()))) continue;
                JSONObject buttonActionJsonObj = bottomButtonJsonObj.getJSONObject("action");
                Integer buttonType = buttonActionJsonObj.getInteger("type");
                BottomButtonDigiwinAthena bottomButton = BottomButtonDigiwinAthena.create((UiBotAction)pcUiBotAction, (String)bizDataSchema, (Object)bizData, null, (Action)new Action(buttonType));
                if (bottomButton.getAction().getRawData() instanceof ButtonRawData) {
                    ButtonRawData buttonRawData = (ButtonRawData)bottomButton.getAction().getRawData();
                    Map map = buttonRawData.getData();
                    if (pcUiBotAction.getSubmitType() != null && StringUtils.isNotBlank((String)pcUiBotAction.getSubmitType().getSchema())) {
                        String schema = pcUiBotAction.getSubmitType().getSchema();
                        map.put(schema, pcUiBotModel.getPageData().get((Object)schema));
                    }
                }
                result.add((Object)bottomButton);
            }
        }
        ModuleUtils.addRefreshPageId((BottomButtonList)result, (String)"");
        return result;
    }
}

