/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate;

import com.digiwin.mobile.mobileuibot.core.component.chart.ChartTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.NoneCoordinate;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.RectangleCoordinate;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.axis.Axis;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.axis.AxisTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.axis.RectangleAxis;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.ChartElement;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDataItem;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.DataObserveResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.ChartRenderSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ChartCoordinate
extends ChartElement {
    private static final Logger log = LoggerFactory.getLogger(ChartCoordinate.class);
    private static final long serialVersionUID = 5534062764572878832L;
    protected String category;
    protected List<Double> centerPixel;
    protected List<String> centerPercent;

    public ChartCoordinate() {
        this.initCategory();
    }

    protected void initCategory() {
    }

    public void addXAxis(RectangleAxis axis) {
    }

    public void addMultipleXAxis(List<RectangleAxis> axes) {
    }

    public void addYAxis(RectangleAxis axis) {
    }

    public void addMultipleYAxis(List<RectangleAxis> axes) {
    }

    public void setRadiusAxis(Axis axis) {
    }

    public void setAngleAxis(Axis axis) {
    }

    public static ChartCoordinate buildChartCoordinate(AgileDataIntermediateDataItem intermediateDataItem, ChartTypeEnum chartTypeEnum) {
        Object coordinate;
        ChartRenderSetting chartRenderSetting = intermediateDataItem.getChartRenderSetting();
        List points = chartRenderSetting.getPoints();
        List values = chartRenderSetting.getValues();
        if (ChartTypeEnum.LINE == chartTypeEnum || ChartTypeEnum.BAR == chartTypeEnum || ChartTypeEnum.MIXED == chartTypeEnum) {
            coordinate = new RectangleCoordinate();
            List xAxes = points.stream().map(point -> {
                RectangleAxis xAxis = new RectangleAxis(AxisTypeEnum.CATEGORY.getValue());
                xAxis.setName(point.getTitle());
                List xAxisData = intermediateDataItem.getSeriesDataWithFieldId(point.getName());
                xAxis.setData(xAxisData);
                return xAxis;
            }).collect(Collectors.toList());
            Map groupedValueFields = intermediateDataItem.getGroupedValueFields();
            ArrayList<RectangleAxis> yAxes = new ArrayList<RectangleAxis>(2);
            for (Integer groupNo : groupedValueFields.keySet()) {
                RectangleAxis yAxis = new RectangleAxis(AxisTypeEnum.VALUE.getValue());
                DataObserveResult observeResult = intermediateDataItem.getExactDataObserveResult(groupNo);
                List yData = observeResult.calculatePreferredAxisDatas();
                ChartCoordinate.setMinAndMaxValue((List)yData, (RectangleAxis)yAxis);
                yAxis.setInterval(observeResult.getPreferredAxisInterval());
                yAxis.setData(yData);
                yAxes.add(yAxis);
            }
            coordinate.addMultipleXAxis(xAxes);
            coordinate.addMultipleYAxis(yAxes);
        } else {
            coordinate = chartTypeEnum == ChartTypeEnum.PIE ? new NoneCoordinate() : (chartTypeEnum == ChartTypeEnum.SCATTER ? new RectangleCoordinate() : new NoneCoordinate());
        }
        return coordinate;
    }

    private static void setMinAndMaxValue(List<String> yData, RectangleAxis yAxis) {
        if (CollectionUtils.isEmpty(yData)) {
            return;
        }
        try {
            yAxis.setMin(Double.valueOf(ChartCoordinate.parseValue((String)yData.get(0))));
            yAxis.setMax(Double.valueOf(ChartCoordinate.parseValue((String)yData.get(yData.size() - 1))));
        }
        catch (NumberFormatException e) {
            log.error("Error parsing yData values: {}", (Object)e.getMessage());
        }
    }

    private static double parseValue(String value) {
        if (value.contains(",")) {
            value = value.replaceAll(",", "");
        } else if (value.contains("%")) {
            value = value.replaceAll("%", "");
            return Double.parseDouble(value) / 100.0;
        }
        return Double.parseDouble(value);
    }

    public String getCategory() {
        return this.category;
    }

    public List<Double> getCenterPixel() {
        return this.centerPixel;
    }

    public List<String> getCenterPercent() {
        return this.centerPercent;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setCenterPixel(List<Double> centerPixel) {
        this.centerPixel = centerPixel;
    }

    public void setCenterPercent(List<String> centerPercent) {
        this.centerPercent = centerPercent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartCoordinate)) {
            return false;
        }
        ChartCoordinate other = (ChartCoordinate)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        List this$centerPixel = this.getCenterPixel();
        List other$centerPixel = other.getCenterPixel();
        if (this$centerPixel == null ? other$centerPixel != null : !((Object)this$centerPixel).equals(other$centerPixel)) {
            return false;
        }
        List this$centerPercent = this.getCenterPercent();
        List other$centerPercent = other.getCenterPercent();
        return !(this$centerPercent == null ? other$centerPercent != null : !((Object)this$centerPercent).equals(other$centerPercent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChartCoordinate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        List $centerPixel = this.getCenterPixel();
        result = result * 59 + ($centerPixel == null ? 43 : ((Object)$centerPixel).hashCode());
        List $centerPercent = this.getCenterPercent();
        result = result * 59 + ($centerPercent == null ? 43 : ((Object)$centerPercent).hashCode());
        return result;
    }

    public String toString() {
        return "ChartCoordinate(category=" + this.getCategory() + ", centerPixel=" + this.getCenterPixel() + ", centerPercent=" + this.getCenterPercent() + ")";
    }
}

