/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.chart.mobilechart;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.CommonRawDataParentType;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.DataSource;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.chart.mobilechart.ChartData;
import com.digiwin.mobile.mobileuibot.core.component.chart.mobilechart.FontPositionEnum;
import com.digiwin.mobile.mobileuibot.core.component.chart.mobilechart.LayoutStyleEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotJumpAction;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.CollectionUtils;

public class IndicatorChart
extends BaseMobileComponent {
    private static final long serialVersionUID = -6054261048980053277L;
    public static final String COMPONENT_TYPE = "CHART_INDICATOR";
    private String title;
    private Boolean titleVisible = false;
    Boolean thousandthPlace = true;
    private Integer fontPosition = FontPositionEnum.FONT_ABOVE.getType();
    private Boolean slide = false;
    private Integer layoutStyle = LayoutStyleEnum.NEWLINE.getType();
    private DataSource dataSource;
    private List<ChartData> chartData;

    /*
     * Enabled aggressive block sorting
     */
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        Map rawMap;
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.layoutStyle = BooleanUtils.isTrue((Boolean)this.slide) ? LayoutStyleEnum.LEVEL.getType() : LayoutStyleEnum.NEWLINE.getType();
        super.resetCmptMultipleDataSourceData(cmptContext, executeContext, this.dataSource, data);
        Object value = UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema);
        if (ObjectUtils.isEmpty((Object)value)) {
            this.setDefaultValue(this.chartData);
            return;
        }
        if (value instanceof Map) {
            rawMap = (Map)JsonUtil.objectToJavaObject((Object)value, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            if (!(value instanceof List)) {
                this.setDefaultValue(this.chartData);
                return;
            }
            if (CollectionUtils.isEmpty((Collection)((List)value))) {
                this.setDefaultValue(this.chartData);
                return;
            }
            rawMap = (Map)((List)JsonUtil.objectToJavaObject((Object)value, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).get(0);
        }
        Iterator iterator = this.chartData.iterator();
        while (iterator.hasNext()) {
            ChartData chart = (ChartData)iterator.next();
            chart.setValue(String.valueOf(rawMap.get(chart.getSchema())));
            UiBotJumpAction uiBotJumpAction = chart.getSetting().getAction();
            if (!ObjectUtils.isNotEmpty((Object)uiBotJumpAction)) continue;
            Button button = new Button();
            UiBotAction UiBotAction2 = new UiBotAction();
            UiBotAction2.setBtnType("jump");
            UiBotAction2.setType("");
            UiBotAction2.setJumpAction(uiBotJumpAction);
            button.setSubmitAction(UiBotAction2);
            cmptContext.setCommonRawDataParentType(CommonRawDataParentType.ALONE_BUTTON.getValue());
            button.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
            chart.getSetting().setButton(button);
        }
        return;
    }

    public void setDefaultValue(List<ChartData> chartData) {
        chartData.forEach(chart -> chart.setValue("-1"));
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        IndicatorChart chartIndicator = new IndicatorChart();
        chartIndicator.setComponentId(rawContent.getComponentId());
        Card.DesignerRawCard.Content.IndicatorChartObj chartIndicatorObj = (Card.DesignerRawCard.Content.IndicatorChartObj)JsonUtil.objectToJavaObject((Object)rawContent.getSetting(), Card.DesignerRawCard.Content.IndicatorChartObj.class);
        if (chartIndicatorObj != null) {
            chartIndicator.setTitle(chartIndicatorObj.getTitle());
            chartIndicator.setTitleVisible(chartIndicatorObj.getTitleVisible());
            chartIndicator.setChartData(chartIndicatorObj.getChartData());
            chartIndicator.setThousandthPlace(chartIndicatorObj.getThousandthPlace());
        }
        chartIndicator.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return chartIndicator;
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public String getTitle() {
        return this.title;
    }

    public Boolean getTitleVisible() {
        return this.titleVisible;
    }

    public Boolean getThousandthPlace() {
        return this.thousandthPlace;
    }

    public Integer getFontPosition() {
        return this.fontPosition;
    }

    public Boolean getSlide() {
        return this.slide;
    }

    public Integer getLayoutStyle() {
        return this.layoutStyle;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public List<ChartData> getChartData() {
        return this.chartData;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitleVisible(Boolean titleVisible) {
        this.titleVisible = titleVisible;
    }

    public void setThousandthPlace(Boolean thousandthPlace) {
        this.thousandthPlace = thousandthPlace;
    }

    public void setFontPosition(Integer fontPosition) {
        this.fontPosition = fontPosition;
    }

    public void setSlide(Boolean slide) {
        this.slide = slide;
    }

    public void setLayoutStyle(Integer layoutStyle) {
        this.layoutStyle = layoutStyle;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setChartData(List<ChartData> chartData) {
        this.chartData = chartData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndicatorChart)) {
            return false;
        }
        IndicatorChart other = (IndicatorChart)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$titleVisible = this.getTitleVisible();
        Boolean other$titleVisible = other.getTitleVisible();
        if (this$titleVisible == null ? other$titleVisible != null : !((Object)this$titleVisible).equals(other$titleVisible)) {
            return false;
        }
        Boolean this$thousandthPlace = this.getThousandthPlace();
        Boolean other$thousandthPlace = other.getThousandthPlace();
        if (this$thousandthPlace == null ? other$thousandthPlace != null : !((Object)this$thousandthPlace).equals(other$thousandthPlace)) {
            return false;
        }
        Integer this$fontPosition = this.getFontPosition();
        Integer other$fontPosition = other.getFontPosition();
        if (this$fontPosition == null ? other$fontPosition != null : !((Object)this$fontPosition).equals(other$fontPosition)) {
            return false;
        }
        Boolean this$slide = this.getSlide();
        Boolean other$slide = other.getSlide();
        if (this$slide == null ? other$slide != null : !((Object)this$slide).equals(other$slide)) {
            return false;
        }
        Integer this$layoutStyle = this.getLayoutStyle();
        Integer other$layoutStyle = other.getLayoutStyle();
        if (this$layoutStyle == null ? other$layoutStyle != null : !((Object)this$layoutStyle).equals(other$layoutStyle)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        List this$chartData = this.getChartData();
        List other$chartData = other.getChartData();
        return !(this$chartData == null ? other$chartData != null : !((Object)this$chartData).equals(other$chartData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndicatorChart;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $titleVisible = this.getTitleVisible();
        result = result * 59 + ($titleVisible == null ? 43 : ((Object)$titleVisible).hashCode());
        Boolean $thousandthPlace = this.getThousandthPlace();
        result = result * 59 + ($thousandthPlace == null ? 43 : ((Object)$thousandthPlace).hashCode());
        Integer $fontPosition = this.getFontPosition();
        result = result * 59 + ($fontPosition == null ? 43 : ((Object)$fontPosition).hashCode());
        Boolean $slide = this.getSlide();
        result = result * 59 + ($slide == null ? 43 : ((Object)$slide).hashCode());
        Integer $layoutStyle = this.getLayoutStyle();
        result = result * 59 + ($layoutStyle == null ? 43 : ((Object)$layoutStyle).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        List $chartData = this.getChartData();
        result = result * 59 + ($chartData == null ? 43 : ((Object)$chartData).hashCode());
        return result;
    }

    public String toString() {
        return "IndicatorChart(title=" + this.getTitle() + ", titleVisible=" + this.getTitleVisible() + ", thousandthPlace=" + this.getThousandthPlace() + ", fontPosition=" + this.getFontPosition() + ", slide=" + this.getSlide() + ", layoutStyle=" + this.getLayoutStyle() + ", dataSource=" + this.getDataSource() + ", chartData=" + this.getChartData() + ")";
    }

    public IndicatorChart() {
    }

    public IndicatorChart(String title, Boolean titleVisible, Boolean thousandthPlace, Integer fontPosition, Boolean slide, Integer layoutStyle, DataSource dataSource, List<ChartData> chartData) {
        this.title = title;
        this.titleVisible = titleVisible;
        this.thousandthPlace = thousandthPlace;
        this.fontPosition = fontPosition;
        this.slide = slide;
        this.layoutStyle = layoutStyle;
        this.dataSource = dataSource;
        this.chartData = chartData;
    }
}

