/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InputDateTimePickerParamAnalyzer
implements ComponentParamAnalyzer<InputDateTimePicker, InputDateTime> {
    private static final Logger logger = LoggerFactory.getLogger(InputDateTimePickerParamAnalyzer.class);

    public String getComponentType() {
        return "INPUT_DATETIME_PICKER";
    }

    public Class<InputDateTimePicker> getSubmitParamType() {
        return InputDateTimePicker.class;
    }

    public InputDateTime analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputDateTimePicker)) {
            logger.debug("submitParam is not instanceof InputDateTimePicker component...The data of it is: {}", (Object)JsonUtil.javaObjectToJsonString((Object)submitParam));
            return new InputDateTime();
        }
        InputDateTimePicker inputDateTimePicker = (InputDateTimePicker)submitParam;
        if (null == inputDateTimePicker.getType()) {
            return new InputDateTime();
        }
        InputDateTime inputDateTime = inputDateTimePicker.getDatetimeValue();
        if (inputDateTime == null) {
            return null;
        }
        this.dealDateTime(inputDateTime);
        inputDateTime.setType(inputDateTimePicker.getType());
        return inputDateTime;
    }

    private void dealDateTime(InputDateTime inputDateTime) {
        if (StringUtils.isNotBlank((CharSequence)inputDateTime.getMonth())) {
            inputDateTime.setMonth(this.buildDateTime(inputDateTime.getMonth()));
        }
        if (StringUtils.isNotBlank((CharSequence)inputDateTime.getDate())) {
            inputDateTime.setDate(this.buildDateTime(inputDateTime.getDate()));
        }
        if (StringUtils.isNotBlank((CharSequence)inputDateTime.getHour())) {
            inputDateTime.setHour(this.buildDateTime(inputDateTime.getHour()));
        }
        if (StringUtils.isNotBlank((CharSequence)inputDateTime.getMinute())) {
            inputDateTime.setMinute(this.buildDateTime(inputDateTime.getMinute()));
        }
    }

    private String buildDateTime(String time) {
        if (time.length() < 2) {
            if (time.length() == 1) {
                time = "0" + time;
                return time;
            }
            time = "00";
            return time;
        }
        return time;
    }

    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object ... args) {
    }
}

