/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.numeric;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import java.math.BigDecimal;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="inputNumericParamAnalyzer")
public class InputNumericParamAnalyzer
implements ComponentParamAnalyzer<InputNumeric, Number> {
    private static final Logger logger = LoggerFactory.getLogger(InputNumericParamAnalyzer.class);

    public String getComponentType() {
        return "INPUT_NUMERIC";
    }

    public Class<InputNumeric> getSubmitParamType() {
        return InputNumeric.class;
    }

    public Number analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputNumeric)) {
            logger.debug("submitParam is not instanceof InputNumeric component...The data of it is: {}", (Object)JsonUtil.javaObjectToJsonString((Object)submitParam));
            return null;
        }
        InputNumeric inputNumeric = (InputNumeric)submitParam;
        if (!StringUtils.hasLength((String)inputNumeric.getText())) {
            return null;
        }
        BigDecimal value = new BigDecimal(inputNumeric.getText());
        if (ObjectUtils.isNotEmpty((Object)inputNumeric.getCmptVersion()) && 2 == inputNumeric.getCmptVersion()) {
            return value;
        }
        if (InputNumericTypeEnum.PERCENTAGE.getValue().equals(inputNumeric.getType())) {
            return value.divide(new BigDecimal(100));
        }
        if (InputNumericTypeEnum.INTEGER.getValue().equals(inputNumeric.getType()) || InputNumericTypeEnum.INTEGER_ALLOW_NEGATIVE.getValue().equals(inputNumeric.getType()) || InputNumericTypeEnum.DECIMAL_ALLOW_NEGATIVE.getValue().equals(inputNumeric.getType()) || InputNumericTypeEnum.DECIMAL.getValue().equals(inputNumeric.getType())) {
            return value;
        }
        return null;
    }

    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object ... args) {
    }
}

