/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.picture;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachmentData;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pictureParamAnalyzer")
public class PictureParamAnalyzer
implements ComponentParamAnalyzer<Picture, UiBotAttachment> {
    private static final Logger logger = LoggerFactory.getLogger(PictureParamAnalyzer.class);
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    public String getComponentType() {
        return "PICTURE";
    }

    public Class<Picture> getSubmitParamType() {
        return Picture.class;
    }

    public UiBotAttachment analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof Picture)) {
            logger.debug("submitParam is not instanceof Picture component...The data of it is: {}", (Object)JsonUtil.javaObjectToJsonString((Object)submitParam));
            return UiBotAttachment.createEmpty();
        }
        Picture picture = (Picture)submitParam;
        AttachmentRawDataDigiwinAthena attachmentRawData = (AttachmentRawDataDigiwinAthena)picture.getRawData();
        UiBotAttachment uiBotAttachment = new UiBotAttachment();
        String uploadCategoryId = Optional.ofNullable(attachmentRawData.getUploadCategoryId()).orElse(this.digiwinDmcProxyService.getDirIdByName(attachmentRawData.getUploadCategory(), Optional.ofNullable(attachmentRawData.getBuckets()).orElse("Athena")));
        picture.getFileList().forEach(obj -> {
            AttachmentFile attachmentFile = obj;
            UiBotAttachmentData uiBotAttachmentData = new UiBotAttachmentData();
            uiBotAttachmentData.setId(attachmentFile.getFileId());
            uiBotAttachmentData.setName(attachmentFile.getFileName());
            uiBotAttachmentData.setUploadUserName(attachmentFile.getUploader());
            uiBotAttachmentData.setCreateDate(attachmentFile.getUploadTime());
            uiBotAttachmentData.setSize(Double.valueOf(attachmentFile.getFileSize().doubleValue()));
            uiBotAttachmentData.setShareUrl(attachmentFile.getShareUrl());
            uiBotAttachmentData.setCategory(attachmentRawData.getUploadCategory());
            uiBotAttachmentData.setCategoryId(Optional.ofNullable(uploadCategoryId).orElse(""));
            uiBotAttachmentData.setRowDataKey(attachmentRawData.getRowDataKey());
            uiBotAttachmentData.setBase64Data(attachmentFile.getBase64Data());
            uiBotAttachmentData.setCoverBase64Data(attachmentFile.getCoverBase64Data());
            uiBotAttachmentData.setFileExtension(attachmentFile.getFileExtension());
            uiBotAttachmentData.setBase64DataId(attachmentFile.getBase64DataId());
            uiBotAttachment.addData(uiBotAttachmentData);
        });
        uiBotAttachment.setRowDataKey(attachmentRawData.getRowDataKey());
        return uiBotAttachment;
    }

    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object ... args) {
    }
}

