/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.scan.standard;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.scan.standard.InputScan;
import com.digiwin.mobile.mobileuibot.core.component.input.scan.standard.InputScanTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="inputScanParamAnalyzer")
public class InputScanParamAnalyzer
implements ComponentParamAnalyzer<InputScan, Object> {
    private static final Logger log = LoggerFactory.getLogger(InputScanParamAnalyzer.class);

    public String getComponentType() {
        return "INPUT_SCAN";
    }

    public Class<InputScan> getSubmitParamType() {
        return InputScan.class;
    }

    public Object analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputScan)) {
            log.debug("submitParam is not instanceof InputScan component...The data of it is: {}", (Object)JsonUtil.javaObjectToJsonString((Object)submitParam));
            return null;
        }
        Object value = null;
        InputScan inputScan = (InputScan)submitParam;
        Integer scanType = inputScan.getScanType();
        String text = inputScan.getText();
        if (InputScanTypeEnum.SINGLE_TEXT_SCAN.getValue().equals(scanType)) {
            value = Optional.ofNullable(text).orElse("");
        } else if (InputScanTypeEnum.MULTI_TEXT_SCAN.getValue().equals(scanType)) {
            value = Optional.ofNullable(text).orElse("");
        } else if (InputScanTypeEnum.NUMERIC_SCAN.getValue().equals(scanType) && StringUtils.hasLength((String)text)) {
            value = text.contains(".") ? (Number)Double.parseDouble(text) : (Number)Integer.parseInt(text);
        }
        return value;
    }

    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object ... args) {
    }
}

