/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.singleselect;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ButtonSingleSelectParamAnalyzer
implements ComponentParamAnalyzer<ButtonSingleSelect, Object> {
    private static final Logger log = LoggerFactory.getLogger(ButtonSingleSelectParamAnalyzer.class);

    public String getComponentType() {
        return "BUTTON_SINGLE_SELECT";
    }

    public Class<ButtonSingleSelect> getSubmitParamType() {
        return ButtonSingleSelect.class;
    }

    public Object analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof ButtonSingleSelect)) {
            log.debug("submitParam is not instanceof ButtonSingleSelect component...The data of it is: {}", (Object)JsonUtil.javaObjectToJsonString((Object)submitParam));
            return "";
        }
        ButtonSingleSelect buttonSingleSelect = (ButtonSingleSelect)submitParam;
        if (SingleSelectTypeEnum.MULTI_SELECT.getValue().equals(buttonSingleSelect.getType())) {
            return buttonSingleSelect.getSelectIdList();
        }
        if (CollectionUtils.isEmpty((Collection)buttonSingleSelect.getSelectIdList())) {
            return Optional.ofNullable(buttonSingleSelect.getSelectId()).orElse("");
        }
        return buttonSingleSelect.getSelectIdList().get(0);
    }

    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object ... args) {
        Map displayParam = (Map)pageData.get((Object)pageDataKey);
        List optionList = (List)displayParam.get("optionList");
        if (optionList != null && !optionList.isEmpty()) {
            for (Map option : optionList) {
                option.put("name", LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)((String)option.get("name"))));
            }
        }
    }
}

