/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.singleselect;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="singleSelectListParamAnalyzer")
public class SingleSelectListParamAnalyzer
implements ComponentParamAnalyzer<SingleSelectList, Object> {
    private static final Logger logger = LoggerFactory.getLogger(SingleSelectListParamAnalyzer.class);
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    public String getComponentType() {
        return "SINGLE_SELECT_LIST";
    }

    public Class<SingleSelectList> getSubmitParamType() {
        return SingleSelectList.class;
    }

    public Object analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof SingleSelectList)) {
            logger.debug("submitParam is not instanceof SingleSelectList component...The data of it is: {}", (Object)JsonUtil.javaObjectToJsonString((Object)submitParam));
            return "";
        }
        SingleSelectList selectList = (SingleSelectList)submitParam;
        if (SingleSelectTypeEnum.SINGLE_SELECT.getValue().equals(selectList.getType())) {
            return Optional.ofNullable(selectList.getSelectId()).orElse("");
        }
        return selectList.getSelectIdList();
    }

    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object ... args) {
    }
}

