/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.BasePageDescBuilder;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuildData;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="pageDescBizApprovalBuilder")
public class PageDescBizApprovalBuilder
extends BasePageDescBuilder {
    private static final Logger logger = LoggerFactory.getLogger(PageDescBizApprovalBuilder.class);

    public String getBuilderDetailType() {
        return "BUSINESS_APPROVAL";
    }

    public PageDesc build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<PageDesc> clazz, Object ... args) {
        String locale = apiRequest.getLocale();
        List buildDataList = super.extractBuildData(pcUiBotModel);
        PageDesc pageDesc = PageDesc.createEmpty();
        for (PageDescBuildData buildData : buildDataList) {
            boolean isDescriptionData;
            if (null == buildData.getData()) continue;
            boolean bl = isDescriptionData = null != buildData.getFieldLayoutList();
            if (!isDescriptionData) {
                String title = (String)buildData.getData().get("name");
                String overdueDate = (String)buildData.getData().get("overdueDate");
                String projectName = ProjectStringUtil.getProjectNameOnCard((String)locale, (String)((String)buildData.getData().get("taskStartTime")), (String)((String)buildData.getData().get("taskEndTime")), (String)((String)buildData.getData().get("taskName")), (boolean)false);
                String overduePrefix = LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5df2\u903e\u671f") + "%s";
                DigiwinAtmcBacklogDetail backlogDetail = (DigiwinAtmcBacklogDetail)args[0];
                pageDesc.setTitle(title);
                if (StringUtils.hasLength((String)overdueDate)) {
                    pageDesc.addContent(super.getOverdueDateIconData(), String.format(overduePrefix, overdueDate), PageDescContentTypeEnum.ABNORMAL.getValue());
                }
                if (!StringUtils.hasLength((String)projectName)) continue;
                pageDesc.addContent(super.getProjectNameOnCardIconData(), projectName, PageDescContentTypeEnum.NORMAL.getValue());
                continue;
            }
            super.addDescriptionalDataToPageDesc(pageDesc, buildData);
        }
        return pageDesc;
    }
}

