/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.rule.relation;

import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleSubcategoryEnum;
import java.io.Serializable;
import java.util.Map;
import org.springframework.util.Assert;

public class RelationRuleText
implements Serializable {
    private static final long serialVersionUID = -3458509415602604913L;
    private String condition;
    private Integer conditionOperatorType;
    private Boolean targetEnable;
    private Boolean targetRequired;
    private String targetSchema;
    private Boolean targetHidden;
    private String targetText;
    private String targetPlaceholder;

    public static RelationRuleText create(Map<String, Object> bizData, Rule rule) {
        Assert.notNull((Object)rule, (String)"rule must not null!");
        Assert.isTrue((boolean)rule.getCategory().equalsIgnoreCase(RuleCategoryEnum.RELATION.getCategory()), (String)"rule must be relation category!");
        Assert.isTrue((boolean)rule.getSubcategory().equalsIgnoreCase(RuleSubcategoryEnum.TEXT.getSubcategory()), (String)"rule must be text subcategory!");
        RelationRuleText relationRuleText = new RelationRuleText();
        relationRuleText.setCondition(rule.getCondition());
        relationRuleText.setConditionOperatorType(rule.getConditionOperatorType());
        relationRuleText.setTargetEnable(Boolean.valueOf(rule.calculateTargetPropertyResult(bizData, rule.getTargetEnable())));
        relationRuleText.setTargetRequired(Boolean.valueOf(rule.calculateTargetPropertyResult(bizData, rule.getTargetRequired())));
        relationRuleText.setTargetHidden(Boolean.valueOf(rule.calculateTargetPropertyResult(bizData, rule.getTargetHidden())));
        relationRuleText.setTargetSchema(rule.getTargetSchema());
        relationRuleText.setTargetText(rule.getTargetText());
        relationRuleText.setTargetPlaceholder(rule.getTargetPlaceholder());
        return relationRuleText;
    }

    public String getCondition() {
        return this.condition;
    }

    public Integer getConditionOperatorType() {
        return this.conditionOperatorType;
    }

    public Boolean getTargetEnable() {
        return this.targetEnable;
    }

    public Boolean getTargetRequired() {
        return this.targetRequired;
    }

    public String getTargetSchema() {
        return this.targetSchema;
    }

    public Boolean getTargetHidden() {
        return this.targetHidden;
    }

    public String getTargetText() {
        return this.targetText;
    }

    public String getTargetPlaceholder() {
        return this.targetPlaceholder;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setConditionOperatorType(Integer conditionOperatorType) {
        this.conditionOperatorType = conditionOperatorType;
    }

    public void setTargetEnable(Boolean targetEnable) {
        this.targetEnable = targetEnable;
    }

    public void setTargetRequired(Boolean targetRequired) {
        this.targetRequired = targetRequired;
    }

    public void setTargetSchema(String targetSchema) {
        this.targetSchema = targetSchema;
    }

    public void setTargetHidden(Boolean targetHidden) {
        this.targetHidden = targetHidden;
    }

    public void setTargetText(String targetText) {
        this.targetText = targetText;
    }

    public void setTargetPlaceholder(String targetPlaceholder) {
        this.targetPlaceholder = targetPlaceholder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelationRuleText)) {
            return false;
        }
        RelationRuleText other = (RelationRuleText)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$conditionOperatorType = this.getConditionOperatorType();
        Integer other$conditionOperatorType = other.getConditionOperatorType();
        if (this$conditionOperatorType == null ? other$conditionOperatorType != null : !((Object)this$conditionOperatorType).equals(other$conditionOperatorType)) {
            return false;
        }
        Boolean this$targetEnable = this.getTargetEnable();
        Boolean other$targetEnable = other.getTargetEnable();
        if (this$targetEnable == null ? other$targetEnable != null : !((Object)this$targetEnable).equals(other$targetEnable)) {
            return false;
        }
        Boolean this$targetRequired = this.getTargetRequired();
        Boolean other$targetRequired = other.getTargetRequired();
        if (this$targetRequired == null ? other$targetRequired != null : !((Object)this$targetRequired).equals(other$targetRequired)) {
            return false;
        }
        Boolean this$targetHidden = this.getTargetHidden();
        Boolean other$targetHidden = other.getTargetHidden();
        if (this$targetHidden == null ? other$targetHidden != null : !((Object)this$targetHidden).equals(other$targetHidden)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        String this$targetSchema = this.getTargetSchema();
        String other$targetSchema = other.getTargetSchema();
        if (this$targetSchema == null ? other$targetSchema != null : !this$targetSchema.equals(other$targetSchema)) {
            return false;
        }
        String this$targetText = this.getTargetText();
        String other$targetText = other.getTargetText();
        if (this$targetText == null ? other$targetText != null : !this$targetText.equals(other$targetText)) {
            return false;
        }
        String this$targetPlaceholder = this.getTargetPlaceholder();
        String other$targetPlaceholder = other.getTargetPlaceholder();
        return !(this$targetPlaceholder == null ? other$targetPlaceholder != null : !this$targetPlaceholder.equals(other$targetPlaceholder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelationRuleText;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $conditionOperatorType = this.getConditionOperatorType();
        result = result * 59 + ($conditionOperatorType == null ? 43 : ((Object)$conditionOperatorType).hashCode());
        Boolean $targetEnable = this.getTargetEnable();
        result = result * 59 + ($targetEnable == null ? 43 : ((Object)$targetEnable).hashCode());
        Boolean $targetRequired = this.getTargetRequired();
        result = result * 59 + ($targetRequired == null ? 43 : ((Object)$targetRequired).hashCode());
        Boolean $targetHidden = this.getTargetHidden();
        result = result * 59 + ($targetHidden == null ? 43 : ((Object)$targetHidden).hashCode());
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        String $targetSchema = this.getTargetSchema();
        result = result * 59 + ($targetSchema == null ? 43 : $targetSchema.hashCode());
        String $targetText = this.getTargetText();
        result = result * 59 + ($targetText == null ? 43 : $targetText.hashCode());
        String $targetPlaceholder = this.getTargetPlaceholder();
        result = result * 59 + ($targetPlaceholder == null ? 43 : $targetPlaceholder.hashCode());
        return result;
    }

    public String toString() {
        return "RelationRuleText(condition=" + this.getCondition() + ", conditionOperatorType=" + this.getConditionOperatorType() + ", targetEnable=" + this.getTargetEnable() + ", targetRequired=" + this.getTargetRequired() + ", targetSchema=" + this.getTargetSchema() + ", targetHidden=" + this.getTargetHidden() + ", targetText=" + this.getTargetText() + ", targetPlaceholder=" + this.getTargetPlaceholder() + ")";
    }
}

