/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItem;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItemEmptyModeEnum;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild.UiBotCompDataBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TodoList;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TodoListResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.task.model.TaskSummary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="uiBotCompDataBuildIndexWorkspaceTripartiteTodoListStrategy")
public class UiBotCompDataBuildIndexWorkspaceTripartiteTodoListStrategy
implements UiBotCompDataBuildStrategy<CustomTabControllerItem> {
    private static final Logger log = LoggerFactory.getLogger(UiBotCompDataBuildIndexWorkspaceTripartiteTodoListStrategy.class);
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private DigiwinSemcProxyService digiwinSemcProxyService;

    public String getTypeByRequestId() {
        return ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TRIPARTITE_TODO_LIST.getReuqestId();
    }

    public CustomTabControllerItem buildComponentData(ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildIndexWorkspaceTripartiteTodoList");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        CustomTabControllerItem customTabControllerItem = useMockData == false && modelTypeShow == false ? this.doActually(apiRequest, stopWatch) : this.doMockData(apiRequest);
        log.debug(stopWatch.prettyPrint());
        return customTabControllerItem;
    }

    private CustomTabControllerItem doActually(ApiRequest apiRequest, StopWatch stopWatch) {
        LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleServiceImpl.class);
        ArrayList<CustomTabContentContainer> content = new ArrayList<CustomTabContentContainer>();
        CustomTabContentContainer taskContent = new CustomTabContentContainer();
        CustomTabContentContainer emptyContent = new CustomTabContentContainer();
        CustomTabContentContainer customButtonContent = new CustomTabContentContainer();
        CustomTabContentContainer blankAreaContent = new CustomTabContentContainer();
        boolean isSearched = false;
        List taskSummaryList = this.getTodoList(apiRequest, localeService);
        if (taskSummaryList.isEmpty()) {
            emptyContent.setContentCmptType("EMPTY");
            emptyContent.setData((Object)Empty.create((String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u6682\u65f6\u6ca1\u6709\u5f85\u529e"), (boolean)true, (Integer)400, (Integer)180, (String)"home_tab_no_work_item_prompt"));
            blankAreaContent.setContentCmptType("BLANK_AREA");
            blankAreaContent.setData((Object)BlankArea.create((Integer)32, (Double)1.0));
            content.add(emptyContent);
            content.add(blankAreaContent);
            content.add(customButtonContent);
            content.add(blankAreaContent);
        } else {
            taskContent.setContentCmptType("TRIPARTITE_TODO_LIST");
            taskContent.setData((Object)taskSummaryList);
            content.add(taskContent);
        }
        return CustomTabControllerItem.createAsyncData((String)localeService.getLanguageValue(apiRequest.getLocale(), "\u4e09\u65b9\u5f85\u529e"), content, (CustomTabControllerItemEmptyModeEnum)CustomTabControllerItemEmptyModeEnum.EMPTY_DATA_AND_UI_WITH_HIDE_MORE, (Boolean)isSearched);
    }

    private CustomTabControllerItem doMockData(ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        CustomTabControllerItem uiBotModel = null;
        String data = FileUtil.readText((String)"static/appstore-use/MyWorkSpaceCardTodoList.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (CustomTabControllerItem)JsonUtil.jsonStringToObject((String)data, CustomTabControllerItem.class);
        }
        return uiBotModel;
    }

    public List<TaskSummary> getTodoList(ApiRequest apiRequest, LocaleService localeService) {
        ApiRawData rawData = apiRequest.getRawData();
        ArrayList<TaskSummary> taskSummaries = new ArrayList<TaskSummary>();
        try {
            CompletableFuture<TodoListResp> supplyAsync = CompletableFuture.supplyAsync(() -> this.digiwinSemcProxyService.selectTodoList(apiRequest.getClientId(), apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), String.valueOf(rawData.get((Object)"appCode")), String.valueOf(rawData.get((Object)"appName")), String.valueOf(rawData.get((Object)"id"))), (Executor)this.threadPoolTaskExecutor);
            TodoListResp todoListResp = supplyAsync.get();
            if (ObjectUtils.isEmpty((Object)todoListResp)) {
                return taskSummaries;
            }
            List todoList = todoListResp.getTodoList();
            if (CollectionUtils.isEmpty((Collection)todoList)) {
                return taskSummaries;
            }
            todoList.forEach(todoData -> {
                if (ObjectUtils.isNotEmpty((Object)todoData)) {
                    taskSummaries.add(TaskSummary.createTripartiteTodo((String)apiRequest.getLocale(), (TodoList)todoData, (LocaleService)localeService));
                }
            });
            return taskSummaries;
        }
        catch (InterruptedException e) {
            log.error("getTodoList interruptedException, error:", (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
        catch (ExecutionException e) {
            String message = e.getMessage();
            if (null != e.getCause()) {
                message = e.getCause().getMessage();
            }
            throw new ServiceException(message);
        }
    }
}

