/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonGroup;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgress;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgressList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcWorkflowPreSign;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcWorkflowProgressHistory;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcWorkflowSignHistory;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressPerson;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressStateEnum;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildWorkflowProgressFixationPageStrategy")
public class UiBotModelBuildWorkflowProgressFixationPageStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && !modelTypeShow ? this.doActually(pageSetting, apiRequest) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        List body;
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        if (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        if (CollectionUtils.isEmpty((Collection)(body = this.buildBody(apiRequest)))) {
            uiBotModel.getRenderData().addEmptyComponentToBody();
        } else {
            uiBotModel.getRenderData().addWrapperedComponentListToBody(body);
        }
        uiBotModel.getRenderData().addWrapperedComponentListToBottom(this.buildBottom(apiRequest));
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return uiBotModel;
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBody(ApiRequest apiRequest) {
        ArrayList<BaseMobileComponentWrapper<BaseMobileComponent>> body = new ArrayList<BaseMobileComponentWrapper<BaseMobileComponent>>();
        BaseMobileComponentWrapper progressListWrapper = this.renderProgressListWrapper(apiRequest);
        if (progressListWrapper != null) {
            body.add((BaseMobileComponentWrapper<BaseMobileComponent>)progressListWrapper);
        }
        return body;
    }

    private BaseMobileComponentWrapper<BaseMobileComponent> renderProgressListWrapper(ApiRequest apiRequest) {
        String serialNumber = apiRequest.getRawData().getString("serialNumber");
        if (!StringUtils.hasLength((String)serialNumber)) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("serialNumber", serialNumber);
        params.put("workItemId", StringUtil.valueOf((Object)apiRequest.getRawData().get((Object)"workItemId")));
        DigiwinAtmcWorkflowProgressHistory progressList = this.digiwinAtmcProxyService.getApprovalWorkflowHistory(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), params);
        if (ObjectUtils.isEmpty((Object)progressList)) {
            return null;
        }
        List taskProgressCmpt = this.buildTaskProgressCmpt(apiRequest.getLocale(), apiRequest.getIamUserToken(), null, progressList);
        if (CollectionUtils.isEmpty((Collection)taskProgressCmpt)) {
            return null;
        }
        TaskProgressList progressListCmpt = new TaskProgressList();
        progressListCmpt.setTaskProgressList(taskProgressCmpt);
        return new BaseMobileComponentWrapper((BaseMobileComponent)progressListCmpt, "DW_TASK_PROGRESS_LIST");
    }

    private List<TaskProgress> buildTaskProgressCmpt(String locale, String iamUserToken, TaskProgressStateEnum taskProgressStateEnum, DigiwinAtmcWorkflowProgressHistory digiwinAtmcWorkflowProgressHistory) {
        if (ObjectUtils.isEmpty((Object)digiwinAtmcWorkflowProgressHistory) || ObjectUtils.isEmpty((Object)digiwinAtmcWorkflowProgressHistory.getData())) {
            return Collections.emptyList();
        }
        List signHistory = digiwinAtmcWorkflowProgressHistory.getData().getSignHistory();
        List preSign = digiwinAtmcWorkflowProgressHistory.getData().getPreSign();
        List<Object> allProgressList = new ArrayList();
        List signHistoryProgressList = signHistory.stream().map(digiwinAtmcWorkflowSignHistory -> TaskProgress.create((String)locale, (DigiwinAtmcWorkflowSignHistory)digiwinAtmcWorkflowSignHistory)).collect(Collectors.toList());
        List preSignProgressList = preSign.stream().map(digiwinAtmcWorkflowPreSign -> TaskProgress.create((String)locale, (DigiwinAtmcWorkflowPreSign)digiwinAtmcWorkflowPreSign)).collect(Collectors.toList());
        allProgressList.addAll(signHistoryProgressList);
        allProgressList.addAll(preSignProgressList);
        if (null != taskProgressStateEnum) {
            allProgressList = allProgressList.stream().filter(taskProgress -> taskProgress.getState().equals(taskProgressStateEnum.getValue())).collect(Collectors.toList());
        }
        ArrayList<String> userIds = new ArrayList<String>();
        for (TaskProgress taskProgress2 : allProgressList) {
            if (CollectionUtils.isEmpty((Collection)taskProgress2.getPersonList())) continue;
            for (TaskProgressPerson taskProgressPerson : taskProgress2.getPersonList()) {
                userIds.add(taskProgressPerson.getUserId());
            }
        }
        List iamUserInfos = this.digiwinIamProxyService.userList(userIds, iamUserToken, locale);
        if (!CollectionUtils.isEmpty((Collection)iamUserInfos)) {
            for (TaskProgress taskProgress3 : allProgressList) {
                if (CollectionUtils.isEmpty((Collection)taskProgress3.getPersonList())) continue;
                block3: for (TaskProgressPerson taskProgressPerson : taskProgress3.getPersonList()) {
                    for (DigiwinIamUserInfo digiwinIamUserInfo : iamUserInfos) {
                        if (!digiwinIamUserInfo.getId().equals(taskProgressPerson.getUserId())) continue;
                        taskProgressPerson.setDigiwinIamUserInfo(digiwinIamUserInfo);
                        continue block3;
                    }
                }
            }
        }
        return allProgressList;
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBottom(ApiRequest apiRequest) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.setContentGroup(this.buildButtonGroupContentGroup(apiRequest));
        return Lists.newArrayList((Object[])new BaseMobileComponentWrapper[]{new BaseMobileComponentWrapper((BaseMobileComponent)buttonGroup, "DW_BUTTON_GROUP")});
    }

    private List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> buildButtonGroupContentGroup(ApiRequest apiRequest) {
        ArrayList<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = new ArrayList<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>>();
        contentGroup.add(this.buildCancelButton(apiRequest));
        return contentGroup;
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildCancelButton(ApiRequest apiRequest) {
        BottomButtonDigiwinAthena cancelButton = BottomButtonDigiwinAthena.createNormalCancelButton((String)apiRequest.getLocale());
        return new BaseMobileComponentWrapper((BaseMobileComponent)cancelButton, "DW_BUTTON");
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

