/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.file;

import com.digiwin.mobile.mobileuibot.api.AgileDataUploadAttachment;
import com.digiwin.mobile.mobileuibot.api.ApiDeleteAttachment;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.ApiSegmentedUploadAttachment;
import com.digiwin.mobile.mobileuibot.api.ApiUploadAttachment;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.file.FileService;
import com.digiwin.mobile.mobileuibot.file.fileupload.UploadFile;
import com.digiwin.mobile.mobileuibot.proxy.aam.service.DigiwinAamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/file"})
public class FileController {
    public static final String ERROR_CODE = "-1";
    public static final String SUCCESS_CODE = "200";
    private static final Logger logger = LoggerFactory.getLogger(FileController.class);
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;
    @Autowired
    private DigiwinAamProxyService digiwinAamProxyService;
    @Autowired
    private FileService fileService;
    @Autowired
    private HttpService httpService;

    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public ApiResponse<Map<String, Object>> upload(ApiUploadAttachment apiAttachment) {
        if (apiAttachment == null) {
            return ApiResponse.buildError((String)"\u8bf7\u6c42\u6570\u636e\u6709\u8bef");
        }
        Map result = this.fileService.uploadFile(apiAttachment, 1);
        if (ERROR_CODE.equals(result.get("code"))) {
            return ApiResponse.buildError((String)((String)result.get("message")));
        }
        return ApiResponse.buildOK().setData((Object)result);
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.GET})
    public ApiResponse<Map<String, Object>> download(@RequestParam String fileId, @RequestParam String iamUserToken, @RequestParam(required=false, defaultValue="{}") String rawDataString) {
        AttachmentRawDataDigiwinAthena attachmentRawData = (AttachmentRawDataDigiwinAthena)JsonUtil.jsonStringToObject((String)rawDataString, AttachmentRawDataDigiwinAthena.class);
        String bucket = Optional.ofNullable(attachmentRawData).map(AttachmentRawDataDigiwinAthena::getBuckets).orElse(null);
        if (StringUtils.isEmpty((String)bucket)) {
            bucket = "Athena";
        }
        String dmcUserToken = this.digiwinDmcProxyService.getDmcUserToken();
        String downUrl = AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2" + "/file/" + bucket + "/preview/" + fileId;
        String dmcPreviewUrl = AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2" + "/file/" + bucket + "/online/preview/url/" + fileId;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("digi-middleware-auth-user", dmcUserToken);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("url", downUrl);
        try {
            ResponseEntity responseEntity = this.httpService.doGet(dmcPreviewUrl, Map.class);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                if (!ObjectUtils.isEmpty((Object)responseEntity.getBody()) && !ObjectUtils.isEmpty(((Map)responseEntity.getBody()).get("data"))) {
                    HashMap data = (HashMap)((Map)responseEntity.getBody()).get("data");
                    dmcPreviewUrl = String.valueOf(data.get("previewUrl"));
                } else {
                    dmcPreviewUrl = null;
                }
            } else {
                dmcPreviewUrl = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dmcPreviewUrl = null;
        }
        dataMap.put("dmcPreviewUrl", dmcPreviewUrl);
        dataMap.put("header", headerMap);
        return ApiResponse.buildOK().setData(dataMap);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ApiResponse<Map<String, Object>> delete(@RequestBody ApiDeleteAttachment apiDeleteAttachment) {
        boolean result;
        Boolean disableAam;
        String fileId = apiDeleteAttachment.getFileId();
        if (StringUtils.isBlank((String)fileId)) {
            return ApiResponse.buildError((String)"fileId\u4e3a\u7a7a");
        }
        AttachmentRawDataDigiwinAthena rawDataDigiwinAthena = apiDeleteAttachment.getRawData();
        HashMap<String, Boolean> dataMap = new HashMap<String, Boolean>();
        if (rawDataDigiwinAthena != null && !Optional.ofNullable(disableAam = rawDataDigiwinAthena.getDisableAam()).orElse(false).booleanValue() && !(result = this.digiwinAamProxyService.deleteFile(fileId, rawDataDigiwinAthena.getUploadCategoryId(), rawDataDigiwinAthena.getUploadCategory(), apiDeleteAttachment.getIamUserToken()))) {
            dataMap.put("success", false);
            return ApiResponse.buildOK().setData(dataMap);
        }
        this.digiwinDmcProxyService.deleteFile(fileId);
        dataMap.put("success", true);
        return ApiResponse.buildOK().setData(dataMap);
    }

    @RequestMapping(value={"/log/upload"}, method={RequestMethod.POST})
    public ApiResponse<Map<String, Object>> upload(UploadFile uploadFile) {
        Map result = this.fileService.uploadFile(uploadFile);
        if (ERROR_CODE.equals(result.get("code"))) {
            return ApiResponse.buildError((String)((String)result.get("message")));
        }
        return ApiResponse.buildOK().setData((Object)result);
    }

    @PostMapping(value={"/segmentedUploadFile"})
    public ApiResponse<String> segmentedUploadFile(ApiSegmentedUploadAttachment apiAttachment) {
        String fileId = this.fileService.segmentedUploadFile(apiAttachment);
        if (fileId == null) {
            return ApiResponse.buildError((String)"\u6587\u4ef6ID\u4e3a\u7a7a,\u4e0a\u4f20\u5931\u8d25");
        }
        return ApiResponse.buildOK().setData((Object)fileId);
    }

    @PostMapping(value={"/uploadFileAgileData"})
    public ApiResponse uploadFileAgileData(@Validated AgileDataUploadAttachment apiAttachment) {
        return this.fileService.uploadFileAgileData(apiAttachment);
    }

    @PostMapping(value={"/getDirFileList"})
    public ApiResponse getDirFileList(@RequestBody ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData((Object)this.fileService.getDirFileList(apiRequest));
    }
}

