/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.common.PortalConstans;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.auxiliary.AuxiliaryLine;
import com.digiwin.mobile.mobileuibot.core.component.business.portal.BusinessComponent;
import com.digiwin.mobile.mobileuibot.core.component.business.portal.BusinessImage;
import com.digiwin.mobile.mobileuibot.core.component.image.BaseImageContent;
import com.digiwin.mobile.mobileuibot.core.component.image.swiper.Swiper;
import com.digiwin.mobile.mobileuibot.core.component.index.TripartiteTodoList;
import com.digiwin.mobile.mobileuibot.core.component.kingkong.Ball;
import com.digiwin.mobile.mobileuibot.core.component.kingkong.BallRouter;
import com.digiwin.mobile.mobileuibot.core.component.kingkong.Dinstrict;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.component.news.News;
import com.digiwin.mobile.mobileuibot.core.component.picture.PictureComponent;
import com.digiwin.mobile.mobileuibot.core.component.picture.PictureHotZone;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabController;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItem;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItemAsyncConfig;
import com.digiwin.mobile.mobileuibot.core.component.title.portal.PortalTitle;
import com.digiwin.mobile.mobileuibot.core.component.title.portal.TitleColor;
import com.digiwin.mobile.mobileuibot.core.component.title.portal.TitleStyle;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.index.IndexBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.LabelSystemData;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileBallResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileCarouselImageInfo;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileCarouselImageResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileDividerResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileNewsResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobilePortalBusImageRespVO;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobilePortalBusinessInfoRespVO;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobilePortalHotZoneRespVO;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobilePortalImageInfoRespVO;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobilePortalInfoContentResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobilePortalInfoResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobilePortalTitleInfoRespVO;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotBizFieldBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.recommend.RecommendService;
import com.digiwin.mobile.mobileuibot.test.TestController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component(value="indexPortalBuildStrategy")
public class IndexPortalBuildStrategy
implements IndexBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(IndexPortalBuildStrategy.class);
    private static final String DIGI_WIN_CLOUD = "digiwincloud";
    private static final String PROJECT = "INDEX-MY_WORKSPACE-CARD_LIST";
    private static final String TASK = "INDEX-MY_WORKSPACE-TODO_LIST";
    @Autowired
    private RecommendService recommendService;
    @Autowired
    private BallRouter ballRouter;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinSemcProxyService digiwinSemcProxyService;
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    public String getIndexType() {
        return PageSettingIdPresetEnum.INDEX_PORTAL.toString();
    }

    public UiBotModel build(ApiRequest apiRequest, PageSetting pageSetting, Boolean hasProjectData) {
        UiBotRenderData renderData = UiBotRenderData.createEmptyRenderData();
        ArrayList body = new ArrayList();
        renderData.setBody(body);
        UiBotModel uiBotModel = pageSetting.getPageModel();
        uiBotModel.setRenderData(renderData);
        uiBotModel.setRenderVersion(Integer.valueOf(2));
        MobilePortalInfoResp mobilePortalInfo = this.digiwinSemcProxyService.getMobilePortalInfo(apiRequest.getLocale(), apiRequest.getIamUserToken(), Long.valueOf(apiRequest.getDataId()), Integer.valueOf(apiRequest.getExtraParameter().getScene() == null ? 0 : apiRequest.getExtraParameter().getScene()), apiRequest.getExtraParameter().getPageType());
        if (!ObjectUtils.isEmpty((Object)mobilePortalInfo) && StringUtils.hasText((String)mobilePortalInfo.getRecentlyMsg())) {
            String msg = this.localeService.getLanguageValue(apiRequest.getLocale(), mobilePortalInfo.getRecentlyMsg());
            throw new ServiceException(msg);
        }
        List mobilePortalInfoContentRespList = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)mobilePortalInfo) && !CollectionUtils.isEmpty((Collection)mobilePortalInfo.getContentList())) {
            mobilePortalInfoContentRespList = mobilePortalInfo.getContentList();
        }
        UiBotPageData pageData = uiBotModel.getPageData();
        List uiBotModelLayout = uiBotModel.getLayout();
        Map mobileComponentMap = uiBotModelLayout.stream().filter(x -> pageData.get((Object)x.getSchema()) != null).collect(Collectors.toMap(UiBotBizFieldBase::getType, Function.identity(), (a, b) -> a));
        if (null != mobilePortalInfo.getPortalType() && mobilePortalInfo.getPortalType().equals(PortalConstans.MobilePortalTypeEnum.PORTAL.getFlag())) {
            this.buildIndexNavBar(mobileComponentMap, body, pageData, apiRequest);
        }
        if (null != mobilePortalInfo.getPortalType() && mobilePortalInfo.getPortalType().equals(PortalConstans.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
            uiBotModel.setPageTitle(mobilePortalInfo.getTitle());
            uiBotModel.setPageBackgroudColor(mobilePortalInfo.getBgColor());
        }
        List<Object> mobilePortalInfoContentRespsNew = new ArrayList();
        List kingKongList = mobilePortalInfoContentRespList.stream().filter(x -> x.getContentType().equals(PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue()) && PortalConstans.DistrictCustomTypeEnum.USER_TYPE.getValue().equals(x.getCustomType())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(kingKongList)) {
            List kingKongNullList = kingKongList.stream().filter(x -> CollectionUtils.isEmpty((Collection)x.getBallList())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(kingKongNullList)) {
                if (kingKongNullList.size() == kingKongList.size()) {
                    boolean hasNull = false;
                    for (MobilePortalInfoContentResp contentResp : mobilePortalInfoContentRespList) {
                        if (contentResp.getContentType().equals(PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue()) && CollectionUtils.isEmpty((Collection)contentResp.getBallList()) && !hasNull) {
                            MobilePortalInfoContentResp mobilePortalInfoContentResp = new MobilePortalInfoContentResp();
                            mobilePortalInfoContentResp.setContentType(Integer.valueOf(0));
                            mobilePortalInfoContentResp.setCustomType(Integer.valueOf(1));
                            mobilePortalInfoContentRespsNew.add(mobilePortalInfoContentResp);
                            hasNull = true;
                        }
                        if (!contentResp.getContentType().equals(PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue())) {
                            mobilePortalInfoContentRespsNew.add(contentResp);
                        }
                        if (!contentResp.getContentType().equals(PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue()) || !PortalConstans.DistrictCustomTypeEnum.TENANT_TYPE.getValue().equals(contentResp.getCustomType())) continue;
                        mobilePortalInfoContentRespsNew.add(contentResp);
                    }
                } else {
                    mobilePortalInfoContentRespsNew = mobilePortalInfoContentRespList.stream().filter(x -> !x.getContentType().equals(PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue()) || !CollectionUtils.isEmpty((Collection)x.getBallList())).collect(Collectors.toList());
                }
            } else {
                mobilePortalInfoContentRespsNew = mobilePortalInfoContentRespList;
            }
        } else {
            mobilePortalInfoContentRespsNew = mobilePortalInfoContentRespList;
        }
        mobilePortalInfoContentRespsNew.forEach(x -> {
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.PRE_TASK.getValue())) {
                CustomTabControllerItem taskItem = this.buildTaskAndProject(mobileComponentMap, pageData, apiRequest, PortalConstans.PreComponentEnum.PRE_TASK.getValue());
                this.setProjectAndTask(taskItem, body);
            }
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.PRE_PROJECT.getValue())) {
                CustomTabControllerItem projectItem = this.buildTaskAndProject(mobileComponentMap, pageData, apiRequest, PortalConstans.PreComponentEnum.PRE_PROJECT.getValue());
                this.setProjectAndTask(projectItem, body);
            }
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.TRIPARTITE_TO_DO.getValue())) {
                CustomTabControllerItem thirdTodoItem = this.buildTaskAndProject(mobileComponentMap, pageData, apiRequest, PortalConstans.PreComponentEnum.TRIPARTITE_TO_DO.getValue());
                this.setProjectAndTask(thirdTodoItem, body);
            }
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue())) {
                this.setKingKongDistrictAndBall(body, x, apiRequest);
            }
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.PRE_CAROUSEL.getValue())) {
                this.setCarouselImageModule(body, x, apiRequest);
            }
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.PRE_NEWS.getValue())) {
                this.setNewsModule(body, x, apiRequest);
            }
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.DIVIDER.getValue())) {
                this.setDividerInfo(body, x);
            }
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.TITLE.getValue())) {
                this.setTitleInfoModule(body, x, apiRequest);
            }
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.PICTURE.getValue())) {
                this.setPictureModule(body, x, apiRequest);
            }
            if (x.getContentType().equals(PortalConstans.PreComponentEnum.BUSINESS_ENTRANCE.getValue())) {
                this.setBusinessModule(body, x, apiRequest);
            }
        });
        uiBotModel.setPageData(new UiBotPageData());
        uiBotModel.setLayout(new ArrayList());
        return uiBotModel;
    }

    private void buildIndexNavBar(Map<String, UiBotLayout> mobileComponentMap, List<BaseMobileComponentWrapper<BaseMobileComponent>> body, UiBotPageData pageData, ApiRequest apiRequest) {
        if (mobileComponentMap.containsKey("INDEX_NAVBAR")) {
            UiBotLayout navBarComponent = mobileComponentMap.get("INDEX_NAVBAR");
            IndexNavBar indexNavBar = (IndexNavBar)JsonUtil.objectToJavaObject((Object)pageData.get((Object)navBarComponent.getSchema()), IndexNavBar.class);
            indexNavBar.initSetting(apiRequest.getLocale(), apiRequest.getAppInfo());
            if (!TestController.specialHandleSwitch()) {
                indexNavBar.initShortcutButton(apiRequest, this.projectService, this.localeService);
            }
            indexNavBar.setCmptVersion(Integer.valueOf(2));
            BaseMobileComponentWrapper navBarWrapper = new BaseMobileComponentWrapper((BaseMobileComponent)indexNavBar);
            navBarWrapper.setComponentType("DW_INDEX_NAVBAR");
            body.add((BaseMobileComponentWrapper<BaseMobileComponent>)navBarWrapper);
        }
    }

    private void setKingKongDistrictAndBall(List<BaseMobileComponentWrapper<BaseMobileComponent>> body, MobilePortalInfoContentResp districtInfo, ApiRequest apiRequest) {
        Dinstrict dinstrict = new Dinstrict();
        BaseMobileComponentWrapper componentWrapper = new BaseMobileComponentWrapper((BaseMobileComponent)dinstrict);
        componentWrapper.setComponentType("DW_" + dinstrict.returnComponentType());
        body.add((BaseMobileComponentWrapper<BaseMobileComponent>)componentWrapper);
        this.buildCustomGroup(dinstrict, districtInfo);
        ArrayList<Ball> balls = new ArrayList<Ball>();
        List ballList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)districtInfo.getBallList())) {
            ballList = districtInfo.getBallList();
        }
        for (MobileBallResp ballResp : ballList) {
            Ball ball = new Ball();
            ball.setIcon(ballResp.getIconUrl());
            ball.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), ballResp.getBallName()));
            ball.setType(ballResp.getJumpType());
            Action action = this.packageComponetAction(ballResp.getJumpType(), ballResp.getJumpTarget(), ballResp.getCustomApplicationId(), apiRequest);
            ball.setActionEvent(action);
            balls.add(ball);
        }
        dinstrict.setComponentsData(balls);
    }

    private CustomTabControllerItem buildTaskAndProject(Map<String, UiBotLayout> mobileComponentMap, UiBotPageData pageData, ApiRequest apiRequest, Integer type) {
        if (mobileComponentMap.containsKey("CUSTOM_TAB_CONTROLLER")) {
            CustomTabControllerItem todoItem;
            CustomTabControllerItem projectItem;
            CustomTabControllerItem taskItem;
            UiBotLayout customLayout = mobileComponentMap.get("CUSTOM_TAB_CONTROLLER");
            CustomTabController customTabController = (CustomTabController)JsonUtil.objectToJavaObject((Object)pageData.get((Object)customLayout.getSchema()), CustomTabController.class);
            List tabItems = customTabController.getTabItems();
            if (type.equals(PortalConstans.PreComponentEnum.PRE_TASK.getValue()) && !ObjectUtils.isEmpty((Object)(taskItem = (CustomTabControllerItem)tabItems.stream().filter(y -> y.getId().equals(ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TODO_LIST.getReuqestId())).findFirst().orElse(null)))) {
                this.buildAsyncForData(taskItem, apiRequest);
                return taskItem;
            }
            if (type.equals(PortalConstans.PreComponentEnum.PRE_PROJECT.getValue()) && !ObjectUtils.isEmpty((Object)(projectItem = (CustomTabControllerItem)tabItems.stream().filter(y -> y.getId().equals(ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_CARD_LIST.getReuqestId())).findFirst().orElse(null)))) {
                this.buildAsyncForData(projectItem, apiRequest);
                return projectItem;
            }
            if (type.equals(PortalConstans.PreComponentEnum.TRIPARTITE_TO_DO.getValue()) && !ObjectUtils.isEmpty((Object)(todoItem = (CustomTabControllerItem)tabItems.stream().filter(y -> y.getId().equals(ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TRIPARTITE_TODO_LIST.getReuqestId())).findFirst().orElse(null)))) {
                try {
                    CompletableFuture<Boolean> asyncBoolean = CompletableFuture.supplyAsync(() -> this.digiwinSemcProxyService.queryStatus(apiRequest.getClientId(), apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()), (Executor)this.threadPoolTaskExecutor);
                    if (asyncBoolean.get().booleanValue()) {
                        CompletableFuture<List> supplyAsync = CompletableFuture.supplyAsync(() -> this.digiwinSemcProxyService.getTripartiteToDoList(apiRequest.getClientId(), apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()), (Executor)this.threadPoolTaskExecutor);
                        List tripartiteTodoList = supplyAsync.get();
                        this.buildTripartiteToDoData(apiRequest, tripartiteTodoList, todoItem);
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    String message = e.getMessage();
                    if (null != e.getCause()) {
                        message = e.getCause().getMessage();
                    }
                    log.error("async deal tripartite todo error:{}", (Object)message, (Object)e);
                }
                return todoItem;
            }
        }
        return new CustomTabControllerItem();
    }

    private void buildAsyncForData(CustomTabControllerItem item, ApiRequest apiRequest) {
        if (item.getAsyncForData().booleanValue()) {
            CustomTabControllerItemAsyncConfig asyncConfig = item.getAsyncConfig();
            asyncConfig.setIamUserToken(apiRequest.getIamUserToken());
            asyncConfig.setLocale(apiRequest.getLocale());
            asyncConfig.setClientId(apiRequest.getClientId());
            asyncConfig.setTenantId(apiRequest.getTenantId());
            String configuredUrl = asyncConfig.getRequestUrl();
            String newUrl = AppContext.getBaseUrl() + configuredUrl + "?clientId=" + apiRequest.getClientId() + "&tenantId=" + apiRequest.getTenantId();
            asyncConfig.setRequestUrl(newUrl);
        }
        item.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), item.getName()));
        item.setJumpPageTitle(this.localeService.getLanguageValue(apiRequest.getLocale(), item.getJumpPageTitle()));
    }

    private void buildTripartiteToDoData(ApiRequest apiRequest, List<LabelSystemData> labelSystemDataList, CustomTabControllerItem item) {
        if (item.getAsyncForData().booleanValue()) {
            CustomTabControllerItemAsyncConfig asyncConfig = item.getAsyncConfig();
            asyncConfig.setIamUserToken(apiRequest.getIamUserToken());
            asyncConfig.setLocale(apiRequest.getLocale());
            asyncConfig.setClientId(apiRequest.getClientId());
            asyncConfig.setTenantId(apiRequest.getTenantId());
            String configuredUrl = asyncConfig.getRequestUrl();
            String newUrl = AppContext.getBaseUrl() + configuredUrl + "?clientId=" + apiRequest.getClientId() + "&tenantId=" + apiRequest.getTenantId();
            asyncConfig.setRequestUrl(newUrl);
            ArrayList<CustomTabContentContainer> content = new ArrayList<CustomTabContentContainer>();
            CustomTabContentContainer taskContent = new CustomTabContentContainer();
            HashMap dataMap = new HashMap();
            if (CollectionUtils.isEmpty(labelSystemDataList)) {
                taskContent.setContentCmptType("TRIPARTITE_TODO_LIST");
                taskContent.setData(dataMap);
                content.add(taskContent);
                item.setContent(content);
                item.setAsyncConfig(null);
                return;
            }
            ArrayList tripartiteTodoLists = new ArrayList();
            labelSystemDataList.forEach(labelSystemData -> {
                TripartiteTodoList tripartite = new TripartiteTodoList();
                tripartite.setNodeName(labelSystemData.getAppName());
                tripartite.setNodeId(String.valueOf(labelSystemData.getId()));
                tripartite.setIsExpand(Boolean.valueOf(true));
                tripartite.setAsyncConfig(asyncConfig);
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                rowData.put("id", labelSystemData.getId());
                rowData.put("appCode", labelSystemData.getAppId());
                rowData.put("appName", labelSystemData.getAppName());
                rowData.put("callBackUrl", labelSystemData.getCallBackUrl());
                rowData.put("protocolType", labelSystemData.getProtocolType());
                rowData.put("isNeedSsoUrl", labelSystemData.getIsNeedSsoUrl());
                rowData.put("isFixedRefresh", labelSystemData.getIsFixedRefresh());
                tripartite.setRawData(rowData);
                tripartiteTodoLists.add(tripartite);
            });
            taskContent.setContentCmptType("TRIPARTITE_TODO_LIST");
            dataMap.put("data", tripartiteTodoLists);
            taskContent.setData(dataMap);
            content.add(taskContent);
            item.setContent(content);
            item.setAsyncConfig(null);
        }
    }

    private void setProjectAndTask(CustomTabControllerItem item, List<BaseMobileComponentWrapper<BaseMobileComponent>> body) {
        BaseMobileComponentWrapper component = new BaseMobileComponentWrapper((BaseMobileComponent)item);
        component.setComponentType("DW_CUSTOM_ASYNC_LIST_VIEW");
        body.add((BaseMobileComponentWrapper<BaseMobileComponent>)component);
    }

    private void buildCustomGroup(Dinstrict dinstrict, MobilePortalInfoContentResp districtInfo) {
        dinstrict.setCmptVersion(Integer.valueOf(2));
        dinstrict.setColumnNum(districtInfo.getColumnNum());
        dinstrict.setDisplayText(districtInfo.getIsNameShow());
        dinstrict.setLineNum(districtInfo.getLineNum());
        dinstrict.setCustomType(districtInfo.getCustomType());
        dinstrict.setInteractionType(districtInfo.getInteractionType());
        dinstrict.setTitle(districtInfo.getTitle());
        dinstrict.setIsTitleShow(districtInfo.getIsTitleShow());
        dinstrict.setColumnId(districtInfo.getColumnId());
    }

    private void setCarouselImageModule(List<BaseMobileComponentWrapper<BaseMobileComponent>> body, MobilePortalInfoContentResp districtInfo, ApiRequest apiRequest) {
        Swiper swiper = new Swiper();
        BaseMobileComponentWrapper componentWrapper = new BaseMobileComponentWrapper((BaseMobileComponent)swiper);
        componentWrapper.setComponentType("DW_" + swiper.returnComponentType());
        body.add((BaseMobileComponentWrapper<BaseMobileComponent>)componentWrapper);
        this.buildCustomGroup(swiper, districtInfo);
        ArrayList<BaseImageContent> baseImageContentList = new ArrayList<BaseImageContent>();
        MobileCarouselImageResp carouselImageResp = districtInfo.getCarouselInfo();
        if (carouselImageResp != null) {
            swiper.setHeight(carouselImageResp.getHeight());
            swiper.setSizeMode(carouselImageResp.getHeightModel());
            swiper.setBackgroundColor(carouselImageResp.getBackgroundColor());
            swiper.setPaddingFlag(carouselImageResp.getPaddingFlag());
        }
        if (carouselImageResp != null && !CollectionUtils.isEmpty((Collection)carouselImageResp.getImageList())) {
            for (MobileCarouselImageInfo carouselImage : carouselImageResp.getImageList()) {
                BaseImageContent baseImageContent = new BaseImageContent();
                baseImageContent.setData(carouselImage.getContentIcon());
                baseImageContent.setDataType(Integer.valueOf(2));
                Action action = this.packageComponetAction(carouselImage.getJumpType(), carouselImage.getJumpTarget(), carouselImage.getCustomApplicationId(), apiRequest);
                baseImageContent.setAction(action);
                baseImageContentList.add(baseImageContent);
            }
        }
        swiper.setContent(baseImageContentList);
    }

    private void buildCustomGroup(Swiper swiper, MobilePortalInfoContentResp districtInfo) {
        swiper.setCmptVersion(Integer.valueOf(2));
        swiper.setAutoPlay(Integer.valueOf(1));
        swiper.setTitle(districtInfo.getContentName());
        swiper.setTitleStyleType(Integer.valueOf(3));
    }

    private void setNewsModule(List<BaseMobileComponentWrapper<BaseMobileComponent>> body, MobilePortalInfoContentResp districtInfo, ApiRequest apiRequest) {
        News news = new News();
        BaseMobileComponentWrapper componentWrapper = new BaseMobileComponentWrapper((BaseMobileComponent)news);
        componentWrapper.setComponentType("DW_" + news.returnComponentType());
        body.add((BaseMobileComponentWrapper<BaseMobileComponent>)componentWrapper);
        news.setCmptVersion(Integer.valueOf(2));
        news.setTitle(districtInfo.getContentName());
        MobileNewsResp mobileNewsResp = districtInfo.getNewsInfo();
        if (mobileNewsResp != null) {
            news.setShowPublishTime(mobileNewsResp.getPublishTimeFlag());
            news.setShowReadCount(mobileNewsResp.getReadNumFlag());
            news.setStyle(mobileNewsResp.getNewsModel());
            news.setNewsTypeId(Integer.valueOf(!ObjectUtils.isEmpty((Object)mobileNewsResp.getNewsTypeId()) ? mobileNewsResp.getNewsTypeId() : -1));
            news.setChildrenNewsTypeId(mobileNewsResp.getChildrenNewsTypeId());
            news.setNewsCount(mobileNewsResp.getNewsCount());
            news.setNewsLikeCountFlag(mobileNewsResp.getNewsLikeCountFlag());
        }
    }

    private void setDividerInfo(List<BaseMobileComponentWrapper<BaseMobileComponent>> body, MobilePortalInfoContentResp districtInfo) {
        AuxiliaryLine auxiliaryLine = new AuxiliaryLine();
        BaseMobileComponentWrapper componentWrapper = new BaseMobileComponentWrapper((BaseMobileComponent)auxiliaryLine);
        componentWrapper.setComponentType("DW_" + auxiliaryLine.returnComponentType());
        body.add((BaseMobileComponentWrapper<BaseMobileComponent>)componentWrapper);
        auxiliaryLine.setCmptVersion(Integer.valueOf(2));
        MobileDividerResp dividerInfo = districtInfo.getDividerInfo();
        if (!ObjectUtils.isEmpty((Object)dividerInfo)) {
            auxiliaryLine.setHeight(dividerInfo.getHeight());
            auxiliaryLine.setBackgroundColor(dividerInfo.getBackgroundColor());
            auxiliaryLine.setLineStyleFlag(dividerInfo.getLineStyleFlag());
            auxiliaryLine.setLineColor(dividerInfo.getLineColor());
        }
    }

    private void setTitleInfoModule(List<BaseMobileComponentWrapper<BaseMobileComponent>> body, MobilePortalInfoContentResp districtInfo, ApiRequest apiRequest) {
        PortalTitle title = new PortalTitle();
        BaseMobileComponentWrapper componentWrapper = new BaseMobileComponentWrapper((BaseMobileComponent)title);
        componentWrapper.setComponentType("DW_" + title.returnComponentType());
        body.add((BaseMobileComponentWrapper<BaseMobileComponent>)componentWrapper);
        MobilePortalTitleInfoRespVO titleInfo = districtInfo.getTitleInfo();
        if (null == titleInfo) {
            return;
        }
        title.setBackgroundColor(titleInfo.getBackgroundColor());
        title.setTitle(titleInfo.getMainTitleName());
        title.setSubTitle(titleInfo.getSubTitleName());
        TitleColor titleTextStyle = new TitleColor();
        titleTextStyle.setColor(titleInfo.getMainTitleColor());
        title.setTitleTextStyle(titleTextStyle);
        TitleColor subTitleTextStyle = new TitleColor();
        subTitleTextStyle.setColor(titleInfo.getSubTitleColor());
        title.setSubTitleTextStyle(subTitleTextStyle);
        title.setLinkFlag(titleInfo.getLinkFlag());
        if (null != titleInfo.getLinkFlag() && titleInfo.getLinkFlag().equals(PortalConstans.IconFlagEnum.IS_SHOW.getFlag())) {
            TitleColor rightTitleTextStyle = new TitleColor();
            rightTitleTextStyle.setColor(titleInfo.getLinkColor());
            title.setRightTitle(titleInfo.getLinkName());
            title.setRightTitleTextStyle(rightTitleTextStyle);
            Action action = this.packageComponetAction(titleInfo.getJumpType(), titleInfo.getJumpTarget(), titleInfo.getCustomApplicationId(), apiRequest);
            title.setAction(action);
        }
        TitleStyle leaderStyle = new TitleStyle();
        leaderStyle.setIcon(titleInfo.getIconUrl());
        if (titleInfo.getIconFlag().equals(PortalConstans.IconFlagEnum.NO_SHOW.getFlag())) {
            leaderStyle.setStyle(PortalConstans.LeaderStyleEnum.EMPTY.getVal());
        }
        if (titleInfo.getIconFlag().equals(PortalConstans.IconFlagEnum.IS_SHOW.getFlag())) {
            Integer style = titleInfo.getIconStyle().equals(PortalConstans.IconStyleEnum.COLOR.getVal()) ? PortalConstans.LeaderStyleEnum.COLOR.getVal() : PortalConstans.LeaderStyleEnum.ICON.getVal();
            leaderStyle.setStyle(style);
        }
        leaderStyle.setColor(titleInfo.getIconColor());
        leaderStyle.setIconType(PortalConstans.IconTypeEnum.NET_WORK.getVal());
        title.setLeaderStyle(leaderStyle);
    }

    private void setPictureModule(List<BaseMobileComponentWrapper<BaseMobileComponent>> body, MobilePortalInfoContentResp districtInfo, ApiRequest apiRequest) {
        PictureComponent picture = new PictureComponent();
        BaseMobileComponentWrapper componentWrapper = new BaseMobileComponentWrapper((BaseMobileComponent)picture);
        componentWrapper.setComponentType("DW_" + picture.returnComponentType());
        body.add((BaseMobileComponentWrapper<BaseMobileComponent>)componentWrapper);
        MobilePortalImageInfoRespVO imageCompInfo = districtInfo.getImageCompInfo();
        if (null == imageCompInfo) {
            return;
        }
        picture.setPicUrl(imageCompInfo.getImageUrl());
        ArrayList<PictureHotZone> areaList = new ArrayList<PictureHotZone>();
        for (MobilePortalHotZoneRespVO hotZone : imageCompInfo.getHotZoneList()) {
            PictureHotZone area = new PictureHotZone();
            Action action = this.packageComponetAction(hotZone.getJumpType(), hotZone.getJumpTarget(), hotZone.getCustomApplicationId(), apiRequest);
            area.setAction(action);
            area.setPosition(hotZone.getCoordinate());
            areaList.add(area);
        }
        picture.setArea(areaList);
    }

    private void setBusinessModule(List<BaseMobileComponentWrapper<BaseMobileComponent>> body, MobilePortalInfoContentResp districtInfo, ApiRequest apiRequest) {
        BusinessComponent business = new BusinessComponent();
        BaseMobileComponentWrapper componentWrapper = new BaseMobileComponentWrapper((BaseMobileComponent)business);
        componentWrapper.setComponentType("DW_" + business.returnComponentType());
        body.add((BaseMobileComponentWrapper<BaseMobileComponent>)componentWrapper);
        MobilePortalBusinessInfoRespVO businessCompInfo = districtInfo.getBusinessCompInfo();
        if (null == businessCompInfo) {
            return;
        }
        business.setStyle(businessCompInfo.getBusStyle());
        business.setBackgroundColor(businessCompInfo.getBusBgColor());
        ArrayList<BusinessImage> imageList = new ArrayList<BusinessImage>();
        for (MobilePortalBusImageRespVO imageRespVO : businessCompInfo.getImageList()) {
            BusinessImage iamge = new BusinessImage();
            Action action = this.packageComponetAction(imageRespVO.getJumpType(), imageRespVO.getJumpTarget(), imageRespVO.getCustomApplicationId(), apiRequest);
            iamge.setAction(action);
            iamge.setPicUrl(imageRespVO.getImageUrl());
            imageList.add(iamge);
        }
        business.setData(imageList);
    }

    public Action packageComponetAction(Integer jumpType, String jumpTarget, Long customApplicationId, ApiRequest apiRequest) {
        MobileBallResp mobileBallResp;
        Action action = null;
        if (PortalConstans.JumpTypeEnum.CUSTOMIZE_URL.getValue().equals(jumpType)) {
            mobileBallResp = new MobileBallResp();
            mobileBallResp.setBallName("");
            mobileBallResp.setJumpTarget(jumpTarget);
            action = this.ballRouter.getCompoentAction("Custom", apiRequest, mobileBallResp);
        }
        if (PortalConstans.JumpTypeEnum.SSO_CONFIGURATION.getValue().equals(jumpType)) {
            mobileBallResp = new MobileBallResp();
            mobileBallResp.setCustomApplicationId(customApplicationId);
            mobileBallResp.setCallBackUrl("");
            mobileBallResp.setBallName("");
            action = this.ballRouter.getCompoentAction("CustomApplication", apiRequest, mobileBallResp);
        }
        if (PortalConstans.JumpTypeEnum.COMMONLY_USERD_FUNCTIONS.getValue().equals(jumpType) && StringUtil.isNotEmpty((CharSequence)jumpTarget)) {
            action = this.ballRouter.getCompoentAction(PortalConstans.ActionEnum.getNameByValue((Integer)Integer.valueOf(jumpTarget)), apiRequest, new MobileBallResp());
        }
        if (PortalConstans.JumpTypeEnum.CUSTOM_PAGE.getValue().equals(jumpType)) {
            mobileBallResp = new MobileBallResp();
            mobileBallResp.setJumpTarget(jumpTarget);
            action = this.ballRouter.getCompoentAction("CustomPage", apiRequest, mobileBallResp);
        }
        if (PortalConstans.JumpTypeEnum.MOBILE_NEWS.getValue().equals(jumpType)) {
            mobileBallResp = new MobileBallResp();
            mobileBallResp.setJumpTarget(jumpTarget);
            action = this.ballRouter.getCompoentAction("MobileNews", apiRequest, mobileBallResp);
        }
        if (PortalConstans.JumpTypeEnum.MOBILE_NEWS_TYPE.getValue().equals(jumpType)) {
            mobileBallResp = new MobileBallResp();
            mobileBallResp.setJumpTarget(jumpTarget);
            action = this.ballRouter.getCompoentAction("mobileNewsType", apiRequest, mobileBallResp);
        }
        return action;
    }
}

