/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.information;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.digiwin.mobile.mobileuibot.abireport.ReportCategoryEnum;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.information.InformationService;
import com.digiwin.mobile.mobileuibot.information.request.InformationBoardVO;
import com.digiwin.mobile.mobileuibot.mapper.InformationBoardMapper;
import com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum;
import com.digiwin.mobile.mobileuibot.model.InformationBoard;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InformationServiceImpl
implements InformationService {
    @Autowired
    private InformationBoardMapper boardMapper;
    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;

    public InformationBoard selectByBoardId(String boardId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(InformationBoard::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(InformationBoard::getBoardId, (Object)boardId);
        return (InformationBoard)this.boardMapper.selectOne((Wrapper)wrapper, false);
    }

    public InformationBoard boardAdd(InformationBoardVO vo) {
        InformationBoard board = new InformationBoard().setBoardId(UUIDUtil.getUuid()).setTenantId(vo.getTenantId()).setUserId(vo.getUserId()).setBoardName(vo.getBoardName()).setBoardContent(JsonUtil.javaObjectToJsonString((Object)vo.getBoardContent())).setDelFlag(DelFlagEnum.UNDELETE.getValue()).setCreateTime(new Date());
        this.boardMapper.insert((Object)board);
        return this.selectByBoardId(board.getBoardId());
    }

    public InformationBoard boardUpdate(InformationBoardVO vo) {
        InformationBoard board = new InformationBoard().setBoardId(vo.getBoardId()).setBoardName(vo.getBoardName()).setBoardContent(JsonUtil.javaObjectToJsonString((Object)vo.getBoardContent()));
        this.boardMapper.updateById((Object)board);
        return this.selectByBoardId(board.getBoardId());
    }

    public int boardDelete(String boardId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(InformationBoard::getBoardId, (Object)boardId);
        updateWrapper.eq(InformationBoard::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        updateWrapper.set(InformationBoard::getDelFlag, (Object)DelFlagEnum.DELETE.getValue());
        return this.boardMapper.update(null, (Wrapper)updateWrapper);
    }

    public List<InformationBoard> boardList(String tenantId, String userId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(InformationBoard::getTenantId, (Object)tenantId);
        wrapper.eq(InformationBoard::getUserId, (Object)userId);
        wrapper.eq(InformationBoard::getDelFlag, (Object)DelFlagEnum.UNDELETE.getValue());
        wrapper.orderByDesc(InformationBoard::getUpdateTime);
        List boardList = this.boardMapper.selectList((Wrapper)wrapper);
        return CollectionUtils.isEmpty((Collection)boardList) ? Collections.emptyList() : boardList;
    }

    public List<DigiwinAtmcTmDataReport> reportList(ApiRequest apiRequest) {
        List tmDataList = this.digiwinAudcProxyService.getTmDataList(apiRequest.getClientId(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (CollectionUtils.isEmpty((Collection)tmDataList)) {
            return Collections.emptyList();
        }
        return tmDataList.stream().map(DigiwinAtmcTmData::getBaseItemDtoList).flatMap(Collection::stream).filter(item -> ReportCategoryEnum.STATEMENT.getValue().equals(item.getCategory())).collect(Collectors.toList());
    }
}

