/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.locale;

import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.TranslateService;
import com.digiwin.mobile.mobileuibot.model.LanguageSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/locale"})
public class LocaleController {
    @Autowired
    private LocaleService localeService;
    @Autowired
    private TranslateService translateService;

    @GetMapping(value={"/cache/all"})
    public Boolean cacheAllLanguageSourceList() {
        this.localeService.cacheAllLanguageSourceList();
        return true;
    }

    @PostMapping(value={"/languageSource/add"})
    public Boolean addOrUpdateLanguageSource(@RequestBody LanguageSource languageSource) {
        if (!StringUtils.hasLength((String)languageSource.getPhrase())) {
            return false;
        }
        if (!StringUtils.hasLength((String)languageSource.getLocale())) {
            return false;
        }
        if (!StringUtils.hasLength((String)languageSource.getSourceValue())) {
            return false;
        }
        return this.localeService.addOrUpdateLanguageSource(languageSource);
    }

    @CrossOrigin
    @GetMapping(value={"/translate/zh2Hant/{value}"})
    public String zh2HantForFront(@PathVariable(value="value") String value) {
        return this.translateService.zh2Hant(value);
    }

    @CrossOrigin
    @GetMapping(value={"/translate/zh2En/{value}"})
    public String zh2EnForFront(@PathVariable(value="value") String value) {
        return this.translateService.zh2EN(value);
    }

    @Deprecated
    @CrossOrigin
    @GetMapping(value={"/back/zh2Hant/{value}"})
    public String zh2HantForBack(@PathVariable(value="value") String value) {
        return "result.put(\"dj-mobile-" + value + "\", \"" + this.translateService.zh2Hant(value) + "\");";
    }
}

