/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.locale.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.mobile.mobileuibot.locale.cache.LocaleCache;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.TranslateService;
import com.digiwin.mobile.mobileuibot.mapper.LanguageSourceMapper;
import com.digiwin.mobile.mobileuibot.model.LanguageSource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class LocaleServiceImpl
implements LocaleService {
    private static final Logger logger = LoggerFactory.getLogger(LocaleServiceImpl.class);
    @Autowired
    private LanguageSourceMapper languageSourceMapper;
    @Autowired
    private LocaleCache localeCache;
    @Autowired
    private TranslateService translateService;

    public void cacheAllLanguageSourceList() {
        List languageSourceList = this.languageSourceMapper.selectList((Wrapper)new LambdaQueryWrapper());
        this.localeCache.putLanguageSourceList(languageSourceList);
    }

    public String getLanguageValue(String locale, String phrase) {
        if (!StringUtils.hasLength((String)phrase)) {
            return phrase;
        }
        String sourceValue = this.localeCache.getLanguageCache(locale, phrase);
        if (StringUtils.hasLength((String)sourceValue)) {
            return sourceValue;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(LanguageSource::getLocale, (Object)locale);
        wrapper.eq(LanguageSource::getPhrase, (Object)phrase);
        LanguageSource dbLanguageSource = (LanguageSource)this.languageSourceMapper.selectOne((Wrapper)wrapper, false);
        if (dbLanguageSource != null) {
            this.localeCache.putLanguageSource(dbLanguageSource);
            return dbLanguageSource.getSourceValue();
        }
        LanguageSource zhCnlanguageSource = new LanguageSource(phrase, "zh_CN", phrase);
        this.addOrUpdateLanguageSource(zhCnlanguageSource);
        LanguageSource zhTwlanguageSource = new LanguageSource(phrase, "zh_TW", this.translateService.zh2Hant(phrase));
        this.addOrUpdateLanguageSource(zhTwlanguageSource);
        LanguageSource enUslanguageSource = null;
        if ("en_US".equalsIgnoreCase(locale)) {
            String transalateValueByEn = this.translateService.zh2EN(phrase);
            enUslanguageSource = StringUtils.hasLength((String)transalateValueByEn) ? new LanguageSource(phrase, "en_US", this.translateService.zh2EN(phrase)) : new LanguageSource(phrase, "en_US", zhTwlanguageSource.getSourceValue());
            this.addOrUpdateLanguageSource(enUslanguageSource);
        }
        if ("zh_TW".equalsIgnoreCase(locale) && zhTwlanguageSource != null) {
            return zhTwlanguageSource.getSourceValue();
        }
        if ("en_US".equalsIgnoreCase(locale) && enUslanguageSource != null) {
            return enUslanguageSource.getSourceValue();
        }
        return phrase;
    }

    public Boolean addOrUpdateLanguageSource(LanguageSource languageSource) {
        boolean result;
        if (languageSource == null || !StringUtils.hasLength((String)languageSource.getPhrase())) {
            return false;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(LanguageSource::getLocale, (Object)languageSource.getLocale());
        wrapper.eq(LanguageSource::getPhrase, (Object)languageSource.getPhrase());
        LanguageSource dbLanguageSource = (LanguageSource)this.languageSourceMapper.selectOne((Wrapper)wrapper, false);
        if (dbLanguageSource == null) {
            result = this.languageSourceMapper.insert((Object)languageSource) > 0;
        } else {
            languageSource.setSourceId(dbLanguageSource.getSourceId());
            boolean bl = result = this.languageSourceMapper.updateById((Object)languageSource) > 0;
        }
        if (result) {
            this.localeCache.putLanguageSource(languageSource);
            return true;
        }
        return false;
    }
}

