/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.mongodb.uc;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcMobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.openapi.designer.enums.DataVersionEnum;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class UcMobileDesignerConfigRepository {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="secondMongoTemplate")
    private MongoTemplate secondMongoTemplate;

    public Boolean isExsitTmActivityIdOfUcAppCode(String tmActivityId, String type, String version, Set<String> ucAppCodeList) {
        return this.findOne(tmActivityId, type, version, ucAppCodeList) != null;
    }

    private UcMobileDesignerConfig findOne(String tmActivityId, String type, String version, Set<String> ucAppCodeList) {
        Query queryAll = new Query();
        queryAll.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version)).fields().exclude("data").exclude("rules");
        List list = this.mongoTemplate.find(queryAll, UcMobileDesignerConfig.class).stream().filter(config -> {
            if (CollectionUtils.isEmpty((Collection)ucAppCodeList)) {
                return true;
            }
            return ucAppCodeList.contains(config.getUcAppCode());
        }).filter(config -> config.validWithAppEnvType(AppContext.getEnvType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        String newTmActivityId = null;
        String ucAppCode = null;
        for (UcMobileDesignerConfig designerConfig : list) {
            boolean match = TaskFilter.match((String)tmActivityId, (String)designerConfig.getTmActivityId(), (String)designerConfig.getTmActivityIdMatch());
            if (!match) continue;
            newTmActivityId = designerConfig.getTmActivityId();
            ucAppCode = designerConfig.getUcAppCode();
            break;
        }
        if (newTmActivityId == null) {
            return null;
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type)).addCriteria((CriteriaDefinition)Criteria.where((String)"tmActivityId").is((Object)newTmActivityId)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version)).addCriteria((CriteriaDefinition)Criteria.where((String)"ucAppCode").is((Object)ucAppCode));
        UcMobileDesignerConfig findOne = (UcMobileDesignerConfig)this.mongoTemplate.findOne(query, UcMobileDesignerConfig.class);
        return Optional.ofNullable(findOne).orElse(new UcMobileDesignerConfig()).validWithAppEnvType(AppContext.getEnvType()) != false ? findOne : null;
    }

    public UcMobileDesignerConfig selectOneDsl(String tmActivityId, String type, Set<String> ucAppCodeList) {
        return this.findOne(tmActivityId, type, DataVersionEnum.V1_0.getVersion(), ucAppCodeList);
    }

    public List<UcMobileDesignerConfig> findByType(String type, String version, Set<String> ucAppCodeList) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version)).addCriteria((CriteriaDefinition)Criteria.where((String)"ucAppCode").in(ucAppCodeList));
        return this.mongoTemplate.find(query, UcMobileDesignerConfig.class).stream().filter(config -> config.validWithAppEnvType(AppContext.getEnvType())).collect(Collectors.toList());
    }

    public void deleteByCode(String appCode, String ucAppCode, String version) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"application").is((Object)appCode)).addCriteria((CriteriaDefinition)Criteria.where((String)"ucAppCode").is((Object)ucAppCode)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        this.mongoTemplate.findAllAndRemove(query, UcMobileDesignerConfig.class);
        this.secondMongoTemplate.findAllAndRemove(query, UcMobileDesignerConfig.class);
    }

    public List<UcMobileDesignerConfig> selectByCode(String appCode, String ucAppCode, String version) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"application").is((Object)appCode)).addCriteria((CriteriaDefinition)Criteria.where((String)"ucAppCode").is((Object)ucAppCode)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        List list = this.mongoTemplate.find(query, UcMobileDesignerConfig.class);
        return CollectionUtils.isEmpty((Collection)list) ? new ArrayList() : list;
    }

    public void batchInsert(List<UcMobileDesignerConfig> mobileDesignerConfigs) {
        if (CollectionUtils.isEmpty(mobileDesignerConfigs)) {
            return;
        }
        this.mongoTemplate.insertAll(mobileDesignerConfigs);
        this.secondMongoTemplate.insertAll(mobileDesignerConfigs);
    }

    public void updateData(MobileDesignerConfig config) {
        if (config == null || !StringUtils.hasLength((String)config.getTmActivityId()) || config.getData() == null || !StringUtils.hasLength((String)config.getApplication())) {
            return;
        }
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"tmActivityId").is((Object)config.getTmActivityId())).addCriteria((CriteriaDefinition)Criteria.where((String)"ucAppCode").is((Object)config.getApplication()));
        if (this.mongoTemplate.findOne(query, UcMobileDesignerConfig.class) == null) {
            return;
        }
        Update update = new Update().set("data", (Object)config.getData());
        this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, UcMobileDesignerConfig.class);
        this.secondMongoTemplate.updateMulti(query, (UpdateDefinition)update, UcMobileDesignerConfig.class);
    }
}

