/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.notification.model;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaNotificationTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessage;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageSummary;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class NotificationLabel
implements Serializable {
    private static final long serialVersionUID = -8916553948066495100L;
    private static LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleServiceImpl.class);
    private String text;
    private String type;

    public static NotificationLabel create(String locale, DigiwinAimMessageSummary digiwinAimMessageSummary) {
        return NotificationLabel.getLabelLocalized((String)locale, (String)digiwinAimMessageSummary.getMessage().getCategory());
    }

    public static NotificationLabel create(String locale, DigiwinAimMessage digiwinAimMessage) {
        return NotificationLabel.getLabelLocalized((String)locale, (String)digiwinAimMessage.getCategory());
    }

    @NotNull
    private static NotificationLabel getLabelLocalized(String locale, String messageCategory) {
        String category = messageCategory;
        String text = "";
        if (!StringUtils.hasLength((String)category)) {
            category = AthenaNotificationTypeEnum.NOTICE.toString();
        }
        if (AthenaNotificationTypeEnum.EXCEPTION.toString().equals(category)) {
            text = LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5f02\u5e38");
        } else if (AthenaNotificationTypeEnum.OVERDUE.toString().equals(category)) {
            text = LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f");
        } else if (!AthenaNotificationTypeEnum.NEW.toString().equals(category)) {
            text = AthenaNotificationTypeEnum.EMERGENCY.toString().equals(category) ? LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7d27\u6025") : (AthenaNotificationTypeEnum.NOTICE.toString().equals(category) ? LocaleUtil.getMobileTextByKey((String)locale, (String)"\u901a\u77e5") : (AthenaNotificationTypeEnum.PROXY.toString().equals(category) ? LocaleUtil.getMobileTextByKey((String)locale, (String)"\u4ee3\u7406") : (AthenaNotificationTypeEnum.SIGN_NOTICE.toString().equals(category) ? localeService.getLanguageValue(locale, "\u77e5\u4f1a") : "")));
        }
        return new NotificationLabel(text, category);
    }

    public static NotificationLabel create(String locale, DigiwinAtmcProject digiwinAtmcProject) {
        NotificationLabel label = new NotificationLabel();
        if (digiwinAtmcProject.getEmergency() != 0) {
            label.setText(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7d27\u6025"));
            label.setType(AthenaNotificationTypeEnum.EMERGENCY.toString());
        }
        return label;
    }

    public NotificationLabel() {
    }

    public NotificationLabel(String text, String type) {
        this.text = text;
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

