/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.openapi;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.openapi.designer.request.AppPublishVO;
import com.digiwin.mobile.mobileuibot.openapi.service.OpenApiService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/openapi"})
public class OpenApiController {
    private static final Logger log = LoggerFactory.getLogger(OpenApiController.class);
    @Autowired
    private OpenApiService openApiService;

    @PostMapping(value={"/designer/application/publish"})
    public ApiResponse<Map<String, Object>> publish(@RequestBody AppPublishVO publishVO) {
        log.info("\u8bbe\u8ba1\u5668\u5e94\u7528\u53d1\u7248/\u5207\u677f\u8bf7\u6c42\u53c2\u6570: {}", (Object)JsonUtil.javaObjectToJsonString((Object)publishVO));
        if (publishVO == null || !StringUtils.hasLength((String)publishVO.getAppCode())) {
            return ApiResponse.buildError((String)"appCode can not be empty!");
        }
        if (BooleanUtils.isTrue((Boolean)publishVO.getIndividualCase()) && !StringUtils.hasLength((String)publishVO.getUcAppCode())) {
            return ApiResponse.buildError((String)"ucAppCode can not be empty!");
        }
        this.openApiService.publishOrSwitch(publishVO);
        return ApiResponse.buildOK();
    }

    @PostMapping(value={"/desiginer/dsl/select"})
    public Map<String, Object> selectOneDsl(@RequestBody MobileDesignerConfig config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 0);
        return result;
    }

    @PostMapping(value={"/desiginer/dsl/save"})
    public Map<String, Object> saveDsl(@RequestBody MobileDesignerConfig config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 0);
        this.openApiService.updataData(config);
        return result;
    }

    @GetMapping(value={"/desiginer/dsl/delete/{tmActivityId}"})
    public Map<String, Object> deleteDsl(@PathVariable(value="tmActivityId") String tmActivityId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 0);
        return result;
    }

    @GetMapping(value={"/desiginer/rule/select/{ruleId}"})
    public Map<String, Object> selectOneRule(@PathVariable(value="ruleId") String ruleId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 0);
        return result;
    }

    @GetMapping(value={"/desiginer/rule/selectAll"})
    public Map<String, Object> selectAllRule(@RequestParam(name="code") String code) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 0);
        return result;
    }

    @PostMapping(value={"/desiginer/rule/save"})
    public Map<String, Object> saveRule(@RequestBody JSONObject rule) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 0);
        return result;
    }

    @GetMapping(value={"/desiginer/rule/delete/{ruleId}"})
    public Map<String, Object> deleteRule(@PathVariable(value="ruleId") String ruleId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", 0);
        return result;
    }
}

