/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.pipeline;

import com.digiwin.mobile.mobileuibot.pipeline.Pipeline;
import com.digiwin.mobile.mobileuibot.pipeline.PipelineNode;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class PipelineFactory
implements InitializingBean,
ApplicationContextAware {
    private ApplicationContext appContext;
    @Autowired
    private List<PipelineNode> pipelineNodeList;
    private Map<Class<? extends Pipeline>, List<PipelineNode>> pipelineMap = new ConcurrentHashMap(8);

    public void afterPropertiesSet() throws Exception {
        this.pipelineMap = this.pipelineNodeList.stream().collect(Collectors.groupingBy(PipelineNode::getPipeline));
        this.pipelineMap.keySet().forEach(clazz -> {
            Pipeline pipeline = (Pipeline)this.appContext.getBean(clazz);
            ((List)this.pipelineMap.get(clazz)).stream().sorted(Comparator.comparing(PipelineNode::getNodeOrder, Comparator.reverseOrder())).forEach(arg_0 -> ((Pipeline)pipeline).addPipelineNode(arg_0));
        });
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    public <T> Pipeline<T> getPipeline(Class<? extends Pipeline<T>> clazz) {
        return (Pipeline)this.appContext.getBean(clazz);
    }
}

