/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.printer.service.impl;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource.UiBotMultipleDataSourceService;
import com.digiwin.mobile.mobileuibot.printer.model.AbiReportAsyncExport;
import com.digiwin.mobile.mobileuibot.printer.model.AbiReportSyncExport;
import com.digiwin.mobile.mobileuibot.printer.request.ApiRequestCommand;
import com.digiwin.mobile.mobileuibot.printer.response.PrintTemplateVO;
import com.digiwin.mobile.mobileuibot.printer.service.AbiReportService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPrintAbiData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.bi.model.DigiwinBiUrl;
import com.digiwin.mobile.mobileuibot.proxy.bi.service.DigiwinBiProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.callback.DigiwinEspCallbackManager;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotBusinessConfig;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.ConditionPageService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AbiReportServiceImpl
implements AbiReportService {
    private static final Logger log = LoggerFactory.getLogger(AbiReportServiceImpl.class);
    @Autowired
    private ConditionPageService conditionPageService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinBiProxyService digiwinBiProxyService;
    @Autowired
    private UiBotMultipleDataSourceService uiBotMultipleDataSourceService;

    public String getExportPdfUrl(ApiRequestCommand apiRequest, UiBotModel uiBotModel) {
        if (uiBotModel == null) {
            return null;
        }
        String hashCode = this.buildAbiHashCode(apiRequest, uiBotModel);
        log.info("hashCode: {}", (Object)hashCode);
        if (hashCode == null) {
            return null;
        }
        String resid = Optional.ofNullable(uiBotModel.getRawUiBotPageData()).map(g -> g.get((Object)"STATEMENT__resid")).map(StringUtil::valueOf).orElse(null);
        log.info("resid: {}", (Object)resid);
        if (StringUtils.isEmpty((CharSequence)resid)) {
            return null;
        }
        String application = uiBotModel.getExecuteContext().getString("application");
        String activityName = Optional.ofNullable(uiBotModel.getRawUiBotPageData()).map(g -> g.get((Object)"UIBOT__activityName")).map(StringUtil::valueOf).orElse("");
        return this.abiExportPdf(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), resid, hashCode, application, activityName);
    }

    public UiBotModel getUibotModel(ApiRequestCommand request) {
        UiBotModel uiBotModel = this.buildPageConfig(request);
        return uiBotModel;
    }

    private UiBotModel buildPageConfig(ApiRequestCommand apiRequest) {
        String dataId = apiRequest.getDataId();
        PcUiBotExecuteContext executeContext = PcUiBotExecuteContext.create((String)apiRequest.getLocale(), (String)apiRequest.getTenantId(), (String)dataId);
        executeContext.appendPageInfo("condition-detail", null, dataId, "performer", Boolean.FALSE);
        executeContext.setAuthoredUser(new PcUiBotAuthoredUser().setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId()).setToken(apiRequest.getIamUserToken()));
        return this.conditionPageService.createConditionTemplateForm((ApiRequest)apiRequest, executeContext);
    }

    private String buildAbiHashCode(ApiRequestCommand apiRequest, UiBotModel uiBotModel) {
        if (uiBotModel == null || CollectionUtils.isEmpty((Collection)uiBotModel.getActions())) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("action", uiBotModel.getActions().get(0));
        params.put("data", this.buildAbiData(apiRequest, uiBotModel));
        return this.digiwinAtmcProxyService.getAbiDataCache(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params);
    }

    private Map<String, Object> buildAbiData(ApiRequestCommand apiRequest, UiBotModel uiBotModel) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map map = this.buildRequestParamter(apiRequest);
        if (ObjectUtils.isEmpty((Object)map)) {
            return result;
        }
        result.putAll(map);
        return result;
    }

    private Map<String, Object> buildRequestParamter(ApiRequestCommand apiRequest) {
        Map data = (Map)apiRequest.getRawData().get((Object)"data");
        String mainDataSourceName = Optional.ofNullable(apiRequest.getRawData().getJSONObject("executeContext")).map(r -> r.getString("mainDataSourceName")).orElse(null);
        List sourceData = new ArrayList();
        Object o = data.get(mainDataSourceName);
        if (!(o instanceof List)) {
            return new HashMap<String, Object>();
        }
        sourceData = (List)o;
        List actionParams = (List)apiRequest.getRawData().get((Object)"actionParams");
        if (ObjectUtils.isEmpty((Object)data)) {
            return new HashMap<String, Object>();
        }
        ArrayList transformedData = new ArrayList();
        HashMap<String, Object> realMap = new HashMap<String, Object>();
        String rootSchema = "";
        for (Map item : sourceData) {
            HashMap transformedItem = new HashMap();
            for (Map param : actionParams) {
                String[] key = ((String)param.get("name")).split("\\.");
                String targetKey = key[key.length - 1];
                if (key.length > 1) {
                    rootSchema = key[0];
                }
                String[] value = ((String)param.get("value")).split("\\.");
                String sourceKey = value[value.length - 1];
                Object ob = item.get(sourceKey);
                if (ObjectUtils.isNotEmpty(param.get("typeConverter"))) {
                    try {
                        if ("stringToBooleanConverter".equals(param.get("typeConverter"))) {
                            ob = new DefaultConversionService().convert((Object)ob.toString(), Boolean.TYPE);
                        } else if ("stringToNumberConverter".equals(param.get("typeConverter"))) {
                            ob = new DefaultConversionService().convert((Object)ob.toString(), Integer.TYPE);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u8f6c\u6362\u53c2\u6570\u5931\u8d25", (Throwable)e);
                    }
                }
                transformedItem.put(targetKey, ob);
            }
            transformedData.add(transformedItem);
        }
        if (ObjectUtils.isEmpty((Object)rootSchema)) {
            realMap.put(mainDataSourceName, transformedData);
        } else {
            realMap.put(rootSchema, transformedData);
        }
        return realMap;
    }

    private String abiExportPdf(String iamUserToken, String tenantId, String locale, String resid, String hashCode, String application, String activityName) {
        AbiReportSyncExport export = new AbiReportSyncExport();
        export.setResid(resid);
        export.setExttype("file");
        export.setFiletype("pdf");
        export.setCalcparams(this.getCalcParams(iamUserToken, tenantId, locale, application, hashCode));
        export.setFilename(activityName);
        export.setExportrange("1");
        export.setIszip(Boolean.valueOf(false));
        export.setPdfDataExport(Boolean.valueOf(true));
        export.setPdfAutoPageSize(Boolean.valueOf(true));
        return this.getExportAbiUrlSync(iamUserToken, tenantId, locale, application, export);
    }

    private String getCalcParams(String iamUserToken, String tenantId, String locale, String application, String hashCode) {
        String template = "calcnow=true;refresh=true;showmenu=false;@hashKey={0};@token={1};@routerKey={2};showparams=true;@domainName={3};lang={4};@ReportKey={5}";
        return MessageFormat.format(template, hashCode, iamUserToken, tenantId, AppContext.getApiUrlSetting().getMuiUrl(), locale, application);
    }

    private String getExportAbiUrlFasync(ApiRequest apiRequest, AbiReportAsyncExport export) {
        Map exportData = this.digiwinEspProxyService.getExportAbiUrlFasync(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), export);
        String reqId = (String)exportData.get("digi-reqid");
        CompletableFuture future = new CompletableFuture();
        DigiwinEspCallbackManager.registerCallback((String)reqId, data -> {
            if (!future.isDone()) {
                Map urlMap = (Map)JsonUtil.jsonStringToObject((String)data, Map.class);
                if (ObjectUtils.isNotEmpty((Object)urlMap)) {
                    if (urlMap.get("url") instanceof String) {
                        future.complete((String)urlMap.get("url"));
                    } else {
                        future.complete("");
                    }
                } else {
                    future.complete("");
                }
            }
        });
        try {
            return (String)future.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("InterruptedException while waiting for URL", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error while waiting for URL", e);
        }
    }

    private String getExportAbiUrlSync(String iamUserToken, String tenantId, String locale, String application, AbiReportSyncExport export) {
        DigiwinBiUrl abiUrlResp = this.digiwinBiProxyService.getExportAbiUrlSync(iamUserToken, tenantId, locale, application, export);
        if (ObjectUtils.isEmpty((Object)abiUrlResp)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)abiUrlResp.getData())) {
            return null;
        }
        return abiUrlResp.getData().getDownloadUrl();
    }

    public String getExportPdfUrl(ApiRequestCommand request) {
        PrintTemplateVO printTemplate = request.getPrintTemplate();
        PcUiBotSubmitAction submitAction = (PcUiBotSubmitAction)JsonUtil.objectToJavaObject((Object)request.getRawData().get((Object)"action"), PcUiBotSubmitAction.class);
        if (submitAction == null || printTemplate == null) {
            return null;
        }
        submitAction.setActionParams(printTemplate.getActionParams());
        submitAction.setBusinessConfig(new PcUiBotBusinessConfig().setBusinessId(printTemplate.getTemplateId()).setActivityId(printTemplate.getCode()));
        DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("mobileplatform", request.getLocale(), request.getIamUserToken(), request.getTenantId())).bodyPayloadMap("action", (Object)submitAction).bodyPayloadMap("data", request.getRawData().get((Object)"data")).build();
        DigiwinAtmcPrintAbiData printAbiData = this.digiwinAtmcProxyService.getPrintAbiData(athenaApiRequest);
        if (printAbiData == null) {
            return null;
        }
        String hashCode = printAbiData.getHashCode();
        String resid = printAbiData.getResId();
        log.info("hashCode: {}, resid: {}", (Object)hashCode, (Object)resid);
        if (StringUtils.isEmpty((CharSequence)hashCode) || StringUtils.isEmpty((CharSequence)resid)) {
            return null;
        }
        String application = submitAction.getExecuteContext().getApplication();
        String activityName = printTemplate.getName();
        String locale = Optional.ofNullable(printTemplate.getLocale()).orElse(request.getLocale());
        return this.abiExportPdf(request.getIamUserToken(), request.getTenantId(), locale, resid, hashCode, application, activityName);
    }
}

