/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardProgress;
import com.digiwin.mobile.mobileuibot.core.component.list.card.PageFilterCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.progress.ProgressRate;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.mysql.service.UserProjectFilterService;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterService;
import com.digiwin.mobile.mobileuibot.project.model.GroupRecordRequest;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPersonnelStructure;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/project"})
public class ProjectController {
    private static final Logger logger = LoggerFactory.getLogger(ProjectController.class);
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private ProjectFilterService projectFilterService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private UserProjectFilterService userProjectFilterService;
    @Autowired
    private LocaleService localeService;

    @RequestMapping(value={"/progress/list"})
    public ApiResponse<CardProgress> listProgressRate(@RequestParam(name="iamUserToken") String iamUserToken, @RequestParam(name="tenantId") String tenantId, @RequestParam(name="locale") String locale, @RequestParam(name="projectId") String projectId, @RequestParam(name="isShare") Boolean isShare, @RequestParam(name="pccProjectTypeIsNew") Boolean pccProjectTypeIsNew, String type, Boolean isException) {
        boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (useMockData || modelTypeShow) {
            return ApiResponse.buildOK().setData((Object)this.doMockData(projectId));
        }
        if ("KSC".equalsIgnoreCase(type)) {
            CardProgress cardProgress = this.projectService.getKscProjectProgress(locale, iamUserToken, tenantId, projectId, isShare, isException);
            return ApiResponse.buildOK().setData((Object)cardProgress);
        }
        CardProgress cardProgress = this.projectService.getPccProjectProgress(locale, iamUserToken, tenantId, projectId, isShare, pccProjectTypeIsNew);
        return ApiResponse.buildOK().setData((Object)cardProgress);
    }

    @PostMapping(value={"/search"})
    public ApiResponse<Map> projectSearch(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String iamUserToken = (String)params.get("iamUserToken");
        String locale = (String)params.get("locale");
        String tenantId = (String)params.get("tenantId");
        String queryParam = (String)params.get("queryParam");
        String clientId = (String)params.get("clientId");
        String userId = (String)params.get("userId");
        String pageFilterCode = StringUtil.valueOf(params.get("pageFilterCode"));
        List ids = new ArrayList();
        if (PageFilterCodeEnum.TEAM_PROJECTS.getValue().equals(pageFilterCode)) {
            this.userProjectFilterService.modifyByQueryParam(userId, tenantId, pageFilterCode, queryParam);
            DigiwinAtmcPersonnelStructure personnelStructure = this.digiwinAtmcProxyService.getPersonnelStructure(iamUserToken, tenantId, locale);
            List defaultSelectEmpList = Optional.ofNullable(personnelStructure).map(DigiwinAtmcPersonnelStructure::getAllChildrenDigiwinEmp).orElse(new ArrayList());
            if (!CollectionUtils.isEmpty((Collection)defaultSelectEmpList)) {
                ids = this.digiwinAtmcProxyService.teamProjectSearch(queryParam, defaultSelectEmpList, iamUserToken, tenantId, locale, clientId);
            }
        } else {
            ids = this.digiwinAtmcProxyService.projectSearch(queryParam, iamUserToken, tenantId, locale, clientId);
        }
        HashMap map = new HashMap(1);
        map.put("idList", ids);
        return ApiResponse.buildOK().setData(map);
    }

    @RequestMapping(value={"/hidden/list"}, method={RequestMethod.GET})
    public ApiResponse<List<DigiwinAtmcProject>> listProjectHiddenInApp(@RequestParam(name="clientId") String clientId, @RequestParam(name="locale") String locale, @RequestParam(name="iamUserToken") String iamUserToken, @RequestParam(name="tenantId") String tenantId, @RequestParam(name="appCode") String appCode) {
        List hiddenProjectList = null;
        try {
            List supportedProjectList = this.digiwinAtmcProxyService.listMyProject(clientId, locale, iamUserToken, tenantId).stream().filter(project -> this.projectFilterService.isSupportedProjectByDigiwinAtmcProject(project, tenantId)).collect(Collectors.toList());
            if ("PCC".equals(appCode)) {
                supportedProjectList = supportedProjectList.stream().filter(project -> this.projectFilterService.isCenterConsoleProject(project, tenantId)).collect(Collectors.toList());
                hiddenProjectList = supportedProjectList.stream().filter(project -> CollectionUtils.isEmpty((Collection)project.getTasks())).collect(Collectors.toList());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return CollectionUtils.isEmpty(hiddenProjectList) ? ApiResponse.buildOK().setData(Collections.emptyList()) : ApiResponse.buildOK().setData(hiddenProjectList);
    }

    private List<ProgressRate> doMockData(String projectId) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data = "442382885552192".equals(projectId) ? FileUtil.readText((String)"static/appstore-use/project-progress-list-442382885552192.json") : FileUtil.readText((String)"static/appstore-use/project-progress-list-general.json");
        List progressRateList = (List)JsonUtil.jsonStringToObject((String)data, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return progressRateList;
    }

    @PostMapping(value={"/groupRecord"})
    public ApiResponse<Action<Map<String, Object>>> groupRecord(@RequestBody GroupRecordRequest apiRequest) {
        try {
            if (PageFilterCodeEnum.isExist((String)apiRequest.getPageFilterCode()) && apiRequest.getGroupFilter() != null) {
                this.userProjectFilterService.modifyByGroupFilter(apiRequest.getUserId(), apiRequest.getTenantId(), apiRequest.getPageFilterCode(), JsonUtil.javaObjectToJsonString((Object)apiRequest.getGroupFilter()));
            }
        }
        catch (Exception e) {
            logger.error("projectController.groupRecord error ", (Throwable)e);
        }
        Action action = new Action();
        action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
        action.setToastMsg(this.localeService.getLanguageValue(apiRequest.getLocale(), "\u4fdd\u5b58\u6210\u529f"));
        return ApiResponse.buildOK().setData((Object)action);
    }
}

