/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.filter;

import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilter;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterRepository;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterService;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ProjectFilterServiceImpl
implements ProjectFilterService {
    @Autowired
    private ProjectFilterRepository projectFilterRepository;

    private List<ProjectFilter> findProjectFilter(DigiwinAtmcProject digiwinAtmcProject, String tenantId) {
        List projectFilterList = this.projectFilterRepository.listProjectFilter();
        return projectFilterList.stream().filter(projectFilter -> projectFilter.getContent().getTmTaskId().equalsIgnoreCase(digiwinAtmcProject.getTmTaskId()) && (!StringUtils.hasLength((String)projectFilter.getTenantId()) || tenantId.equalsIgnoreCase(projectFilter.getTenantId()))).collect(Collectors.toList());
    }

    public boolean isCenterConsoleProject(DigiwinAtmcProject digiwinAtmcProject, String tenantId) {
        List projectFilterList = this.findProjectFilter(digiwinAtmcProject, tenantId);
        return projectFilterList.stream().anyMatch(projectFilter -> ProjectFilterTypeEnum.CENTER_CONSOLE.getValue().equalsIgnoreCase(projectFilter.getContent().getType()) && (digiwinAtmcProject.getSubProjectCount() == null || !digiwinAtmcProject.getSubProjectCount().equals(digiwinAtmcProject.getSubProjectFinishedCount())));
    }

    public boolean isSystemCloudHouseKeeper(DigiwinAtmcProject digiwinAtmcProject, String tenantId) {
        List projectFilterList = this.findProjectFilter(digiwinAtmcProject, tenantId);
        return projectFilterList.stream().anyMatch(projectFilter -> ProjectFilterTypeEnum.CLOUD_HOUSE_KEEPER.getValue().equalsIgnoreCase(projectFilter.getContent().getType()));
    }

    public boolean isECNProject(DigiwinAtmcProject digiwinAtmcProject, String tenantId) {
        List projectFilterList = this.findProjectFilter(digiwinAtmcProject, tenantId);
        return projectFilterList.stream().anyMatch(projectFilter -> ProjectFilterTypeEnum.TASK_PROCESS_ECN.getValue().equalsIgnoreCase(projectFilter.getContent().getType()));
    }

    public boolean isStandardProject(DigiwinAtmcProject digiwinAtmcProject, String tenantId) {
        List projectFilterList = this.findProjectFilter(digiwinAtmcProject, tenantId);
        return projectFilterList.stream().anyMatch(projectFilter -> ProjectFilterTypeEnum.STANDARD_PROJECT.getValue().equalsIgnoreCase(projectFilter.getContent().getType()));
    }

    public boolean isSupportedProjectByDigiwinAtmcProject(DigiwinAtmcProject digiwinAtmcProject, String tenantId) {
        return this.isCenterConsoleProject(digiwinAtmcProject, tenantId) || this.isStandardProject(digiwinAtmcProject, tenantId) || this.isSystemCloudHouseKeeper(digiwinAtmcProject, tenantId);
    }
}

