/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.projectplan.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFill;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFillData;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonGroupAlignEnum;
import com.digiwin.mobile.mobileuibot.core.component.divider.Divider;
import com.digiwin.mobile.mobileuibot.core.component.divider.DividerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabsBuilder;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleContent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccApiDataWrapper;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelBuildPccProjectPlanDetailStrategy")
public class UiBotModelBuildPccProjectPlanDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelBuildPccProjectPlanDetailStrategy.class);
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildPccProjectPlanDetailStrategy.class);
    @Autowired
    private CustomTabsBuilder customTabsBuilder;
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Pcc Project Plan Detail");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        String locale = apiRequest.getLocale();
        String tenantId = apiRequest.getTenantId();
        Map rawData = apiRequest.getRawData().getInnerMap();
        Map data = (Map)MapUtil.getOrDefault((Map)rawData, (String)"data", Collections.emptyMap());
        String projectNo = MapUtils.getString((Map)data, (Object)"project_no");
        if (StringUtils.isEmpty((CharSequence)projectNo)) {
            return UiBotModel.emptyUiBotModel();
        }
        Map projectInfo = this.getProjectInfo(apiRequest, projectNo);
        if (CollectionUtils.isEmpty((Map)projectInfo)) {
            return UiBotModel.emptyUiBotModel();
        }
        PccProjectInfo pccProjectInfo = (PccProjectInfo)JsonUtil.objectToJavaObject((Object)projectInfo, PccProjectInfo.class);
        PccApiDataWrapper pccProjectTaskInfoWrapper = this.buildGetProjectTaskInfoCallable(locale, apiRequest.getIamUserToken(), pccProjectInfo, this.digiwinAtdmProxyService, tenantId);
        if (Objects.isNull(pccProjectTaskInfoWrapper) || CollectionUtils.isEmpty((Collection)pccProjectTaskInfoWrapper.getProjectInfoList())) {
            return UiBotModel.emptyUiBotModel();
        }
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    TitleBody titleBody = new TitleBody();
                    TitleContent titleContent = new TitleContent(pccProjectInfo.getProjectNo() + "[" + pccProjectInfo.getProjectName() + "]", new PageDesc());
                    titleBody.setContent(titleContent);
                    ArrayList<Tag> tags = new ArrayList<Tag>(2);
                    Tag propertyTag = Tag.createWriteBgdBlueTextTag((String)ProjectStringUtil.getProjectCCPropertyString((String)apiRequest.getLocale(), (String)pccProjectInfo.getProjectProperty()), (Action)new Action());
                    tags.add(propertyTag);
                    Tag statusTag = Tag.createBlueBgdWriteTextStateTag((String)ProjectStringUtil.getProjectCCStatusString((String)apiRequest.getLocale(), (String)pccProjectInfo.getProjectStatus()));
                    tags.add(statusTag);
                    titleBody.setTags(tags);
                    pageData.put((Object)schema, (Object)titleBody);
                    break;
                }
                case "AUTO_FILL": {
                    AutoFillData autoFillData = new AutoFillData();
                    autoFillData.setName(this.localeService.getLanguageValue(locale, "\u9879\u76ee\u57fa\u7840\u4fe1\u606f"));
                    autoFillData.setNameColor("5037DB");
                    autoFillData.setNameSize("28");
                    Action basicDetailAction = new Action();
                    basicDetailAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_PLAN_CC_PROJECT_BASIC_DETAIL.toString());
                    basicDetailAction.setJumpPageTitle(autoFillData.getName());
                    basicDetailAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    HashMap<String, Map> basicDetailRawData = new HashMap<String, Map>();
                    basicDetailRawData.put("project_info", projectInfo);
                    basicDetailAction.setRawData(basicDetailRawData);
                    autoFillData.setAction(basicDetailAction);
                    AutoFill autoFill = new AutoFill();
                    autoFill.setData(Collections.singletonList(autoFillData));
                    autoFill.setAlign(ButtonGroupAlignEnum.CENTER.getValue());
                    pageData.put((Object)schema, (Object)autoFill);
                    break;
                }
                case "DIVIDER": {
                    Divider divider = Divider.create((DividerTypeEnum)DividerTypeEnum.BLOCK_DIVIDER);
                    pageData.put((Object)schema, (Object)divider);
                    break;
                }
                case "CUSTOM_TABS": {
                    List pccProjectTaskInfo = pccProjectTaskInfoWrapper.getProjectInfoList();
                    CustomTabs customTabs = this.customTabsBuilder.build(apiRequest, pageSetting, UiBotModel.emptyUiBotModel(), CustomTabs.class, new Object[]{layout, pccProjectTaskInfo, pccProjectInfo.getProjectNo(), apiRequest.getTenantId()});
                    pageData.put((Object)schema, (Object)customTabs);
                }
            }
        }
        return uiBotModel;
    }

    private PccApiDataWrapper<PccProjectTaskInfo> buildGetProjectTaskInfoCallable(String locale, String iamUserToken, PccProjectInfo pccProjectInfo, DigiwinAtdmProxyService digiwinAtdmProxyService, String tenantId) {
        HashMap<String, Object> bodyPayloadMap = new HashMap<String, Object>(4);
        String actionId = "task.info.get";
        bodyPayloadMap.put("actionId", actionId);
        HashMap<String, String> projectInfoMap = new HashMap<String, String>();
        projectInfoMap.put("project_no", pccProjectInfo.getProjectNo());
        projectInfoMap.put("task_property", "1");
        projectInfoMap.put("control_mode", "1");
        HashMap parameter = new HashMap(1);
        parameter.put("project_info", Collections.singletonList(projectInfoMap));
        bodyPayloadMap.put("parameter", parameter);
        return digiwinAtdmProxyService.dataQueryByActionProjectTaskInfo(locale, iamUserToken, JsonUtil.javaObjectToJsonString(bodyPayloadMap), tenantId);
    }

    private Map<String, Object> getProjectInfo(ApiRequest apiRequest, String projectNo) {
        HashMap<String, String> projectInfoMap = new HashMap<String, String>(1);
        projectInfoMap.put("project_no", projectNo);
        HashMap parameterMap = new HashMap(2);
        parameterMap.put("project_info", Collections.singletonList(projectInfoMap));
        HashMap<String, Object> requestParamMap = new HashMap<String, Object>(2);
        requestParamMap.put("actionId", "project.common.info.get");
        requestParamMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse employeeInfo = this.digiwinAtdmProxyService.handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", requestParamMap);
        Map<String, Object> projectInfo = Optional.ofNullable(employeeInfo).map(DigiwinAthenaApiResponse::getResponse).map(e -> (List)MapUtil.getOrDefault((Map)e, (String)"project_info", Collections.emptyList())).map(e -> (Map)e.get(0)).orElse(Collections.emptyMap());
        return projectInfo;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

