/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.atmc.service.impl;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcActivityData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogGroup;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogImportanceSetResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogPerformer;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogReadCount;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogSubmitResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcCalendar;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcCardDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcDomain;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEnginePanelInfo;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcFilterSetting;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcOrderSetting;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanel;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanelSource;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanelTask;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPersonnelStructure;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPrintAbiData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPrintTemplate;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPrintTemplateResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectCheckTaskResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectGroup;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectPerformer;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcReassignUser;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcSearchTaskResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTask;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskCardAbstract;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskDebugger;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskProgress;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskReadCount;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskShare;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcWorkflowProgressHistory;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinEmp;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.impl.DigiwinAtmcProxyServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="digiwinAtmcProxyService")
public class DigiwinAtmcProxyServiceImpl
implements DigiwinAtmcProxyService {
    private static final Logger logger = LoggerFactory.getLogger(DigiwinAtmcProxyServiceImpl.class);
    private final HttpService httpService;
    @Autowired
    private TaskFilterService taskFilterService;
    @Autowired
    private ProjectFilterService projectFilterService;

    public DigiwinAtmcProxyServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    public List<DigiwinAtmcBacklog> listMyBacklog(String clientId, String locale, String iamUserToken, String tenantId) throws IOException {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/backlog/list?clientId={clientId}";
        HashMap<String, String> uriVariables = new HashMap<String, String>(1);
        uriVariables.put("clientId", clientId);
        1 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), uriVariables, (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public List<DigiwinAtmcProject> listMyProject(String clientId, String locale, String iamUserToken, String tenantId) throws IOException {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/project/list?clientId={clientId}";
        HashMap<String, String> uriVariables = new HashMap<String, String>(1);
        uriVariables.put("clientId", clientId);
        2 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), uriVariables, (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public DigiwinAtmcProject getDigiwinAtmcProjectByAimMessage(String locale, String iamUserToken, String aimMessageContentId, String aimMessageType) {
        3 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/project/getMainTaskById/" + aimMessageContentId + "/" + aimMessageType;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (DigiwinAtmcProject)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new DigiwinAtmcProject();
    }

    public DigiwinAtmcProjectCheckTaskResult getDigiwinAtmcProjectTaskCheckResult(String locale, String iamUserToken, String projectId, String tmActivityId) {
        4 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/project/list/card/" + projectId + "/" + tmActivityId;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (DigiwinAtmcProjectCheckTaskResult)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new DigiwinAtmcProjectCheckTaskResult();
    }

    public DigiwinAtmcBacklogImportanceSetResult setDigiwinAtmcBacklogImportance(String locale, String iamUserToken, String tenantId, String dataId, String importance) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/backlog/" + dataId + "/importance/" + importance;
        5 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        DigiwinAtmcBacklogImportanceSetResult result = new DigiwinAtmcBacklogImportanceSetResult();
        result.setStatus(Integer.valueOf(statusCode.value()));
        return result;
    }

    public DigiwinAtmcCardDetail getDigiwinAtmcBacklogCardDetail(String locale, String iamUserToken, String dataId) {
        6 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/backlog/list/card/" + dataId;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (DigiwinAtmcCardDetail)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new DigiwinAtmcCardDetail();
    }

    public DigiwinAtmcTaskCardAbstract getDigiwinAtmcBacklogCardAbstract(String locale, String iamUserToken, String tenantId, String dataId, String proxyToken) {
        7 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/backlog/abstract/" + dataId;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId, proxyToken), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (DigiwinAtmcTaskCardAbstract)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new DigiwinAtmcTaskCardAbstract();
    }

    public DigiwinAtmcBacklogReadCount updateDigiwinAtmcBacklogReadCount(String locale, String iamUserToken, String tenantId, String dataId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/backlog/readCount/" + dataId;
        8 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        DigiwinAtmcBacklogReadCount result = new DigiwinAtmcBacklogReadCount();
        result.setStatus(Integer.valueOf(statusCode.value()));
        return result;
    }

    public DigiwinAtmcBacklogDetail getDigiwinAtmcBacklogDetail(String locale, String iamUserToken, String tenantId, String dataId) {
        9 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/backlog/detail/" + dataId;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (DigiwinAtmcBacklogDetail)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new DigiwinAtmcBacklogDetail();
    }

    public DigiwinAtmcBacklogDetail getDigiwinAtmcBacklogDetailByShare(String locale, String iamUserToken, String dataId) {
        10 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/backlog/detail/" + dataId + "?isShared=true";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = statusCode.is2xxSuccessful() ? (DigiwinAtmcBacklogDetail)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new DigiwinAtmcBacklogDetail();
        return digiwinAtmcBacklogDetail;
    }

    public DigiwinAtmcBacklogSubmitResult actionSubmit(String locale, String iamUserToken, String tenantId, Map<String, Object> requestData) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/action/submit";
        String proxyToken = "";
        if (requestData != null && requestData.get("digi-proxy-token") != null) {
            proxyToken = (String)requestData.get("digi-proxy-token");
        }
        11 responseType = new /* Unavailable Anonymous Inner Class!! */;
        logger.error("submit\u7edf\u4e00\u63d0\u4ea4\u53c2\u6570: {}", (Object)JsonUtil.javaObjectToJsonString(requestData));
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId, proxyToken), JsonUtil.javaObjectToJsonString(requestData), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (DigiwinAtmcBacklogSubmitResult)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new DigiwinAtmcBacklogSubmitResult(Integer.valueOf(statusCode.value()), ((DigiwinAthenaApiResponse)responseEntity.getBody()).getErrorMessage());
    }

    public List<DigiwinAtmcTaskProgress> getApprovalTaskSignoffProgress(String locale, String iamUserToken, String tenantId, Map<String, Object> requestData) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/approval/task";
        12 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(requestData), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public DigiwinAtmcCardDetail getDigiwinAtmcProjectCardDetail(String locale, String iamUserToken, String tenantId, String projectId) {
        13 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/project/list/card/" + projectId;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(((DigiwinAthenaApiResponse)responseEntity.getBody()).getErrorMessage());
        }
        return statusCode.is2xxSuccessful() ? (DigiwinAtmcCardDetail)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new DigiwinAtmcCardDetail();
    }

    public DigiwinAtmcTaskReadCount updateDigiwinAtmcTaskReadCount(String locale, String iamUserToken, String tenantId, String dataId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/task/readCount/" + dataId;
        14 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        DigiwinAtmcTaskReadCount result = new DigiwinAtmcTaskReadCount();
        result.setStatus(Integer.valueOf(statusCode.value()));
        return result;
    }

    public DigiwinAtmcPanel getTaskPanel(String locale, String iamUserToken, String tenantId, String dataId) {
        15 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/task/panel/" + dataId;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (DigiwinAtmcPanel)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : DigiwinAtmcPanel.createEmpty();
    }

    public List<DigiwinAtmcTask> getTaskListByProjectId(String projectId, String iamUserToken, String tenantId, String locale) {
        16 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/project/" + projectId + "/tasklist";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public DigiwinAtmcTaskShare getShareTask(String locale, String iamUserToken, String shareCode) {
        17 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/share/task?sharingCode=" + shareCode;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (DigiwinAtmcTaskShare)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new DigiwinAtmcTaskShare();
    }

    public List<DigiwinAtmcTmData> getTmDataList(String clientId, String iamUserToken, String tenantId, String locale) {
        18 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/amtc/v1/commonUsed/tmDataList?plat=1";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(clientId, locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new ArrayList<DigiwinAtmcTmData>();
    }

    public List<DigiwinAtmcCalendar> queryAllTeamMember(String iamUserToken, String locale) {
        19 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/calendar/team/queryAllTeamMember";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new ArrayList<DigiwinAtmcCalendar>();
    }

    public List<DigiwinAtmcBacklog> getTeamMemberWorkItemList(String clientId, String iamUserToken, String teamId, String locale, String startDate, String endDate) {
        20 responseType;
        ResponseEntity responseEntity;
        HttpStatus statusCode;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/calendar/team/member/workitem/list?completed=false&teamId=" + teamId + "&clientId=" + clientId;
        if (StringUtils.hasLength((String)startDate) && StringUtils.hasLength((String)endDate)) {
            url = url + "&startDate=" + startDate + "&endDate=" + endDate;
        }
        return (statusCode = (responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */))).getStatusCode()).is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new ArrayList<DigiwinAtmcBacklog>();
    }

    public DigiwinAtmcEnginePanelInfo getEnginePanelInfoByTaskId(String taskId, String clientId, String iamUserToken, String tenantId, String locale) {
        21 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/task/panel/taskEnginePanelInfo?taskId=" + taskId;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(clientId, locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (DigiwinAtmcEnginePanelInfo)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new DigiwinAtmcEnginePanelInfo();
    }

    public Map<String, DigiwinAtmcPanelSource> getSourcesByMainTaskId(String taskId, String clientId, String iamUserToken, String tenantId, String locale) {
        22 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/task/panel/getSourcesByMainTaskId?taskId=" + taskId;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(clientId, locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (Map)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new HashMap<String, DigiwinAtmcPanelSource>();
    }

    public List<DigiwinAtmcSearchResult> getSearchResult(String iamUserToken, String locale, String name, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/search/result";
        23 responseType = new /* Unavailable Anonymous Inner Class!! */;
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("name", name);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public List<DigiwinAtmcSearchTaskResult> getSearchTaskResult(String iamUserToken, String locale, String queryParam, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/task/mobile/search/backlog/by/param";
        24 responseType = new /* Unavailable Anonymous Inner Class!! */;
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("queryParam", queryParam);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public List<String> projectSearch(String queryParam, String iamUserToken, String tenantId, String locale, String clientId) {
        25 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/taskActivityMessage/findProjectCardIdByParam?queryParam=" + queryParam;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(clientId, locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return new ArrayList<String>();
        }
        List idList = (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
        if (CollectionUtils.isEmpty((Collection)idList)) {
            return new ArrayList<String>();
        }
        return idList.stream().map(StringUtil::valueOf).distinct().collect(Collectors.toList());
    }

    public List<String> teamProjectSearch(String queryParam, List<DigiwinEmp> personnelStructures, String iamUserToken, String tenantId, String locale, String clientId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/taskActivityMessage/findTeamProjectCardIdByParam";
        26 responseType = new /* Unavailable Anonymous Inner Class!! */;
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("queryParam", queryParam);
        params.put("personnelStructures", personnelStructures);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return new ArrayList<String>();
        }
        List idList = (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
        if (CollectionUtils.isEmpty((Collection)idList)) {
            return new ArrayList<String>();
        }
        return idList.stream().map(StringUtil::valueOf).distinct().collect(Collectors.toList());
    }

    public Set<String> taskSearch(String queryParam, String iamUserToken, String tenantId, String locale, String clientId) {
        27 responseType;
        HashSet<String> ids = new HashSet<String>();
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/taskActivityMessage/findTaskCardIdByParam?queryParam=" + queryParam;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(clientId, locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return ids;
        }
        List idList = (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
        if (CollectionUtils.isEmpty((Collection)idList)) {
            return ids;
        }
        idList.forEach(id -> ids.add(id.toString()));
        return ids;
    }

    public DigiwinAtmcPersonnelStructure getPersonnelStructure(String iamUserToken, String tenantId, String locale) {
        28 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/project/departmentProject/personnelStructure";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        if (!responseEntity.getStatusCode().is2xxSuccessful() || responseEntity.getBody() == null || ((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() == null) {
            return null;
        }
        return (DigiwinAtmcPersonnelStructure)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
    }

    public List<DigiwinAtmcProject> selectEmpProject(List<DigiwinEmp> empProject, String iamUserToken, String locale, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/project/depart/selectEmpProject";
        29 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(empProject), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public List<DigiwinAtmcBacklogPerformer> getPerformerListByProjectId(String projectId, String iamUserToken, String locale, String tenantId) {
        30 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/project/tasks/" + projectId;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        if (!responseEntity.getStatusCode().is2xxSuccessful() || responseEntity.getBody() == null || ((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() == null || ((List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse()).size() < 1) {
            ArrayList<DigiwinAtmcBacklogPerformer> test = new ArrayList<DigiwinAtmcBacklogPerformer>(1);
            DigiwinAtmcBacklogPerformer digiwinAtmcBacklogPerformer = new DigiwinAtmcBacklogPerformer();
            digiwinAtmcBacklogPerformer.setBacklogId(Long.valueOf(238429763920064L));
            digiwinAtmcBacklogPerformer.setNeteaseImAccId("test_cnhw_623");
            digiwinAtmcBacklogPerformer.setPerformerId("pur003");
            digiwinAtmcBacklogPerformer.setPerformerName("\u91c7\u8d2d\u4e3b\u7ba11");
            digiwinAtmcBacklogPerformer.setTaskName("\u5de5\u827a\u59d4\u5916\u53eb\u6599\u8ba1\u5212");
            test.add(digiwinAtmcBacklogPerformer);
            return test;
        }
        return (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
    }

    public List<DigiwinAtmcProjectPerformer> getPerformerListByBackLogId(String backLogId, String iamUserToken, String locale, String tenantId) {
        31 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/backlog/personInCharges/" + backLogId;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        if (!responseEntity.getStatusCode().is2xxSuccessful() || responseEntity.getBody() == null || ((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() == null || ((List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse()).size() < 1) {
            ArrayList<DigiwinAtmcProjectPerformer> test = new ArrayList<DigiwinAtmcProjectPerformer>(1);
            DigiwinAtmcProjectPerformer performer = new DigiwinAtmcProjectPerformer();
            performer.setPersonInCharge("pur003");
            performer.setNeteaseImAccId("test_cnhw_623");
            performer.setPersonInChargeName("\u91c7\u8d2d\u4e3b\u7ba11");
            performer.setProjectCardId(Long.valueOf(238429763920064L));
            performer.setProjectCardName("\u5de5\u827a\u59d4\u5916\u53eb\u6599\u8ba1\u5212");
            test.add(performer);
            return test;
        }
        return (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
    }

    public List<DigiwinReassignReport> getTaskReassignReport(String taskId, String iamUserToken, String locale, String tenantId) {
        32 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/reassign/report/TASK/" + taskId;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        if (!responseEntity.getStatusCode().is2xxSuccessful() || responseEntity.getBody() == null || ((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() == null) {
            return Collections.emptyList();
        }
        return (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
    }

    public List<DigiwinReassignReport> getProjectReassignReport(String projectId, String iamUserToken, String locale, String tenantId) {
        33 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/reassign/report/PROJECT/" + projectId;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        if (!responseEntity.getStatusCode().is2xxSuccessful() || responseEntity.getBody() == null || ((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() == null) {
            return Collections.emptyList();
        }
        return (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
    }

    public List<DigiwinAtmcReassignUser> batchGetTaskReassignUsers(DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, String iamUserToken, String locale, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/reassign/batchUsers";
        34 responseType = new /* Unavailable Anonymous Inner Class!! */;
        HashMap<String, Object> requestPayload = new HashMap<String, Object>(3);
        requestPayload.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
        requestPayload.put("category", "TASK");
        requestPayload.put("list", Collections.singletonList(digiwinAtmcBacklogDetail));
        return this.getDigiwinAtmcReassignUsers(iamUserToken, locale, tenantId, url, (ParameterizedTypeReference)responseType, requestPayload);
    }

    public List<DigiwinAtmcReassignUser> batchGetProjectReassignUsers(DigiwinAtmcPanelTask projectDetail, String iamUserToken, String locale, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/reassign/batchUsers";
        35 responseType = new /* Unavailable Anonymous Inner Class!! */;
        HashMap<String, Object> requestPayload = new HashMap<String, Object>(3);
        requestPayload.put("appCode", projectDetail.getAppCode());
        requestPayload.put("category", "PROJECT");
        requestPayload.put("list", Collections.singletonList(projectDetail));
        return this.getDigiwinAtmcReassignUsers(iamUserToken, locale, tenantId, url, (ParameterizedTypeReference)responseType, requestPayload);
    }

    public List<DigiwinAtmcReassignUser> getEligibleUserList(String appCode, String iamUserToken, String locale, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/user/eligible";
        36 responseType = new /* Unavailable Anonymous Inner Class!! */;
        HashMap<String, Object> requestPayload = new HashMap<String, Object>(2);
        if (!"null".equalsIgnoreCase(appCode)) {
            requestPayload.put("appCode", appCode);
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(3);
        HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>(1);
        paramMap.put("bindUser", true);
        map.put("params", paramMap);
        map.put("pageSize", Integer.valueOf(999));
        map.put("pageNum", Integer.valueOf(1));
        requestPayload.put("eocParams", map);
        return this.getDigiwinAtmcReassignUsers(iamUserToken, locale, tenantId, url, (ParameterizedTypeReference)responseType, requestPayload);
    }

    private List<DigiwinAtmcReassignUser> getDigiwinAtmcReassignUsers(String iamUserToken, String locale, String tenantId, String url, ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAtmcReassignUser>>> responseType, Map<String, Object> requestPayload) {
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(requestPayload), responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)Objects.requireNonNull(responseEntity.getBody())).getResponse() : Collections.emptyList();
    }

    public Boolean reassignSubmit(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/reassign";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), Map.class);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException((String)((Map)responseEntity.getBody()).get("errorMessage"));
        }
        return statusCode.is2xxSuccessful();
    }

    public Boolean insertTaskPinning(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/taskPinning/insert";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), Map.class);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException((String)((Map)responseEntity.getBody()).get("errorMessage"));
        }
        return statusCode.is2xxSuccessful();
    }

    public Boolean intelligentMaterialInspectionProject(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/action/submit";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), Map.class);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException((String)((Map)responseEntity.getBody()).get("errorMessage"));
        }
        return statusCode.is2xxSuccessful();
    }

    public List<Map<String, Object>> conditionQueryInBi(String iamUserToken, String tenantId, String locale, String activityCode) {
        37 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/bi/condition/query/" + activityCode;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return Collections.emptyList();
        }
        return (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
    }

    public List<DigiwinAtmcProjectGroup> getDepartProjectGroup(String iamUserToken, String tenantId, String locale, String groupType) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/task/mobile/depart/project/group";
        38 responseType = new /* Unavailable Anonymous Inner Class!! */;
        HashMap<String, String> params = new HashMap<String, String>(1);
        if (!StringUtils.hasLength((String)groupType)) {
            groupType = "teamMember";
        }
        params.put("groupType", groupType);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return Collections.emptyList();
        }
        return (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
    }

    public List<DigiwinAtmcBacklogGroup> getDepartBacklogGroup(String iamUserToken, String tenantId, String locale, String groupType) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/task/mobile/depart/backlog/group";
        39 responseType = new /* Unavailable Anonymous Inner Class!! */;
        HashMap<String, String> params = new HashMap<String, String>(1);
        if (!StringUtils.hasLength((String)groupType)) {
            groupType = "code";
        }
        params.put("groupType", groupType);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful() || responseEntity.getBody() == null || ((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() == null) {
            return Collections.emptyList();
        }
        return (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
    }

    public List<DigiwinAtmcBacklog> getDepartBacklogGroupList(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/task/mobile/depart/backlog/group/list";
        40 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return Collections.emptyList();
        }
        return (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
    }

    public List<DigiwinAtmcProject> getDepartProjectGroupList(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/task/mobile/depart/project/group/list";
        41 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return Collections.emptyList();
        }
        return (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
    }

    public String getAbiDataCache(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/bi/data/cache";
        42 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful() || responseEntity.getBody() == null || ((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() == null || ((Map)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse()).get("hashCode") == null) {
            return "";
        }
        return (String)((Map)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse()).get("hashCode");
    }

    public Boolean deleteAbiCondition(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/bi/condition/delete";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), Map.class);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return false;
        }
        return true;
    }

    public Map<String, Object> saveAbiCondition(String iamUserToken, String tenantId, String locale, Map<String, Object> params, String conditionName) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/bi/condition/save";
        43 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful() || responseEntity.getBody() == null) {
            return Collections.emptyMap();
        }
        List responses = (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
        for (Map response : responses) {
            if (!conditionName.equals(response.get("conditionName"))) continue;
            return response;
        }
        return Collections.emptyMap();
    }

    public DigiwinAtmcActivityData getProjectData(String taskId, PcUiBotExecuteContext executeContext) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/backlog/action/show/" + taskId + "/" + executeContext.getTmActivityId();
        44 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getTenantId()), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(((DigiwinAthenaApiResponse)responseEntity.getBody()).getErrorMessage());
        }
        return (DigiwinAtmcActivityData)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
    }

    public DigiwinAtmcActivityData getTaskData(String backlogId, PcUiBotExecuteContext executeContext) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/backlog/action/edit/" + backlogId + "?isHistory=" + executeContext.getIsHistory();
        45 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getTenantId()), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(((DigiwinAthenaApiResponse)responseEntity.getBody()).getErrorMessage());
        }
        return (DigiwinAtmcActivityData)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
    }

    public DigiwinAtmcWorkflowProgressHistory getApprovalWorkflowHistory(String locale, String iamUserToken, String tenantId, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/approval/workflowHistory";
        46 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            throw new ServiceException(((DigiwinAthenaApiResponse)responseEntity.getBody()).getErrorMessage());
        }
        return (DigiwinAtmcWorkflowProgressHistory)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
    }

    public Boolean backlogImportance(String backlogId, String locale, String iamUserToken, String tenantId, String importanceValue) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/backlog/" + backlogId + "/importance/" + importanceValue;
        47 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(Collections.emptyMap()), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return false;
        }
        return true;
    }

    public Boolean cancelPinning(String locale, String iamUserToken, String tenantId, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/taskPinning/cancelPinning";
        48 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (!statusCode.is2xxSuccessful()) {
            return false;
        }
        return true;
    }

    public Map<String, Object> getBacklogRuleDisplay(String locale, String iamUserToken, String tenantId) {
        49 responseType;
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/backlog/rule/display";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (Map)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyMap();
    }

    public DigiwinAtmcDomain domainSearch(String locale, String iamUserToken, String tenantId, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/domain/search";
        50 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (DigiwinAtmcDomain)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new DigiwinAtmcDomain();
    }

    public List<DigiwinAtmcBacklog> getBacklogListByIds(String locale, String iamUserToken, String tenantId, List<String> backlogIdList) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/backlog/list/byIds";
        HashMap<String, List<String>> params = new HashMap<String, List<String>>(1);
        params.put("backlogIds", backlogIdList);
        51 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public List<DigiwinAtmcOrderSetting> getOrderTaskSetting(String locale, String iamUserToken, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/backlog/setting/order/task";
        52 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), Collections.emptyMap(), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public List<DigiwinAtmcFilterSetting> getFilterTaskSetting(String locale, String iamUserToken, String tenantId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/backlog/setting/filter/task";
        53 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), Collections.emptyMap(), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public List<DigiwinAtmcPrintTemplate> getPrintList(DigiwinAthenaApiRequest athenaApiRequest) {
        StringBuilder urlSbuilder = new StringBuilder(AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/print/list?");
        Map uriVariables = athenaApiRequest.getUriVariables();
        if (!CollectionUtils.isEmpty((Map)uriVariables)) {
            for (String uriVarKey : uriVariables.keySet()) {
                urlSbuilder.append(uriVarKey).append("=").append((String)uriVariables.get(uriVarKey)).append("&");
            }
        }
        String url = urlSbuilder.substring(0, urlSbuilder.length() - 1);
        54 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, athenaApiRequest.getRequestHead(), (ParameterizedTypeReference)responseType);
        if (null == responseEntity || null == responseEntity.getBody() || null == ((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() || !responseEntity.getStatusCode().is2xxSuccessful()) {
            return new ArrayList<DigiwinAtmcPrintTemplate>();
        }
        return ((DigiwinAtmcPrintTemplateResult)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse()).getTemplateList();
    }

    public DigiwinAtmcPrintAbiData getPrintAbiData(DigiwinAthenaApiRequest athenaApiRequest) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/print/label";
        55 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, athenaApiRequest.getRequestHead(), JsonUtil.javaObjectToJsonString((Object)athenaApiRequest.getBodyPayloadMap()), (ParameterizedTypeReference)responseType);
        if (null == responseEntity || null == responseEntity.getBody() || null == ((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() || !responseEntity.getStatusCode().is2xxSuccessful()) {
            return null;
        }
        return (DigiwinAtmcPrintAbiData)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
    }

    public List<List<DigiwinAtmcTaskDebugger>> getTaskDebugger(String locale, String iamUserToken, String tenantId, Long workitemId) {
        String url = AppContext.getApiUrlSetting().getAtmcUrl() + "/api/atmc/v1" + "/debugger/task/" + workitemId;
        56 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), Collections.emptyMap(), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }
}

