/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.dmc.service.impl;

import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.DirInfo;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.dmc.model.SegmentedUploadFileDTO;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import io.micrometer.core.instrument.util.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="digiwinDmcProxyService")
public class DigiwinDmcProxyServiceImpl
implements DigiwinDmcProxyService {
    @Autowired
    private DMC dmcAthenaClient;
    @Autowired
    private DMC dmcFrcClient;
    @Autowired
    private DMC dmcSrmLoadingClient;
    @Autowired
    private DMC dmcKscClient;
    @Autowired
    private DMC dmcTbdsClient;
    @Autowired
    private DMC dmcCtpClient;
    @Autowired
    private DMC dmcSchClient;
    @Autowired
    private DMC agileDataClient;
    @Autowired
    HttpService httpService;
    private final Map<String, DMC> dmcClientMap = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(DigiwinDmcProxyServiceImpl.class);

    @PostConstruct
    private void init() {
        this.dmcClientMap.put("Athena", this.dmcAthenaClient);
        this.dmcClientMap.put("FRC", this.dmcFrcClient);
        this.dmcClientMap.put("srm-loading", this.dmcSrmLoadingClient);
        this.dmcClientMap.put("KSC", this.dmcKscClient);
        this.dmcClientMap.put("tbds", this.dmcTbdsClient);
        this.dmcClientMap.put("CTP", this.dmcCtpClient);
        this.dmcClientMap.put("SCH", this.dmcSchClient);
        this.dmcClientMap.put("asada", this.agileDataClient);
    }

    public FileInfo uploadFile(File file, String dirId) {
        try {
            return this.dmcAthenaClient.upload(file, dirId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new FileInfo();
        }
    }

    public FileInfo uploadFile(InputStream var1, FileInfo var2) {
        try {
            return this.dmcClientMap.getOrDefault(var2.getBucket(), this.dmcAthenaClient).upload(var1, var2);
        }
        catch (Exception e) {
            logger.error("uploadFile\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public FileInfo uploadFile(byte[] fileBytes, String fileName, String dirId) {
        try {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFileName(fileName);
            fileInfo.setDirectoryId(dirId);
            return this.dmcAthenaClient.upload(fileBytes, fileInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new FileInfo();
        }
    }

    public FileInfo uploadFile(byte[] fileBytes, String fileName, String contentType, String dirId, String bucket) {
        try {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFileName(fileName);
            fileInfo.setDirectoryId(dirId);
            if (StringUtils.isNotBlank((String)contentType)) {
                fileInfo.setContentType(contentType);
            }
            if (StringUtils.isBlank((String)dirId)) {
                fileInfo.setDirectoryId("00000000-0000-0000-0000-000000000000");
            }
            return this.dmcClientMap.getOrDefault(bucket, this.dmcAthenaClient).upload(fileBytes, fileInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new FileInfo();
        }
    }

    public String getDmcUserToken() {
        return this.dmcAthenaClient.getToken();
    }

    public String getDmcUserToken(String bucket) {
        return this.dmcClientMap.getOrDefault(bucket, this.dmcAthenaClient).getToken();
    }

    public ShareInfo shareFile(String fileId) {
        try {
            return this.dmcAthenaClient.share(fileId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ShareInfo();
        }
    }

    public ShareInfo shareFile(String fileId, String bucket) {
        try {
            return this.dmcClientMap.getOrDefault(bucket, this.dmcAthenaClient).share(fileId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ShareInfo();
        }
    }

    public String getDirIdByName(String dirName) {
        try {
            DirInfo dirInfo = this.dmcAthenaClient.getDirInfoByName("00000000-0000-0000-0000-000000000000", dirName);
            return dirInfo.getId();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u76ee\u5f55id\u51fa\u9519\u4e86....\u76ee\u5f55\u76ee\u5f55\u540d\u79f0\uff1a" + dirName);
            e.printStackTrace();
            return "";
        }
    }

    public String getDirIdByName(String dirName, String bucket) {
        try {
            DirInfo dirInfo = this.dmcClientMap.getOrDefault(bucket, this.dmcAthenaClient).getDirInfoByName("00000000-0000-0000-0000-000000000000", dirName);
            return dirInfo.getId();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u76ee\u5f55id\u51fa\u9519\u4e86....\u76ee\u5f55\u76ee\u5f55\u540d\u79f0\uff1a" + dirName);
            e.printStackTrace();
            return "";
        }
    }

    public boolean deleteFile(String fileId) {
        try {
            this.dmcAthenaClient.delete(fileId);
        }
        catch (Exception e) {
            logger.error("DMC\u7cfb\u7edf\u5220\u9664\u9644\u4ef6\u51fa\u9519\u4e86....fileID\uff1a" + fileId);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean deleteDir(String dirId, String bucket) {
        try {
            this.dmcClientMap.getOrDefault(bucket, this.dmcAthenaClient).deleteDir(dirId);
        }
        catch (Exception e) {
            logger.error("DMC\u7cfb\u7edf\u5220\u9664\u6307\u5b9a\u76ee\u5f55\u51fa\u9519\u4e86....dirId:{},bucket:{},error:{}", new Object[]{dirId, bucket, e.getMessage(), e});
            return false;
        }
        return true;
    }

    public boolean deleteFile(String fileId, String bucket) {
        try {
            this.dmcClientMap.getOrDefault(bucket, this.dmcAthenaClient).delete(fileId);
        }
        catch (Exception e) {
            logger.error("DMC\u7cfb\u7edf\u5220\u9664\u9644\u4ef6\u51fa\u9519\u4e86....fileID\uff1a" + fileId);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean deleteShare(String shareId, String bucket) {
        try {
            this.dmcClientMap.getOrDefault(bucket, this.dmcAthenaClient).deleteShare(shareId);
        }
        catch (Exception e) {
            logger.error("DMC\u7cfb\u7edf\u5220\u9664\u5206\u4eab\u51fa\u9519\u4e86....shareId\uff1a" + shareId);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public DirInfo createDir(String name) {
        DirInfo dirInfo = new DirInfo();
        try {
            dirInfo.setParentId("00000000-0000-0000-0000-000000000000");
            dirInfo.setName(name);
            dirInfo.setDisplayName(name);
            dirInfo = this.dmcAthenaClient.createDir(dirInfo);
        }
        catch (Exception e) {
            logger.error("DMC\u7cfb\u7edf\u521b\u5efa\u76ee\u5f55\u51fa\u9519\u4e86....dirName\uff1a" + name);
            e.printStackTrace();
            return null;
        }
        return dirInfo;
    }

    public DirInfo createDir(String name, String bucket) {
        DirInfo dirInfo = new DirInfo();
        try {
            dirInfo.setParentId("00000000-0000-0000-0000-000000000000");
            dirInfo.setName(name);
            dirInfo.setDisplayName(name);
            dirInfo = this.dmcClientMap.getOrDefault(bucket, this.dmcAthenaClient).createDir(dirInfo);
        }
        catch (Exception e) {
            logger.error("DMC\u7cfb\u7edf\u521b\u5efa\u76ee\u5f55\u51fa\u9519\u4e86....dirName\uff1a" + name);
            e.printStackTrace();
            return null;
        }
        return dirInfo;
    }

    public DirInfo createDir(String dirId, String name, String bucket) {
        DirInfo dirInfo = new DirInfo();
        try {
            dirInfo.setParentId("00000000-0000-0000-0000-000000000000");
            dirInfo.setId(dirId);
            dirInfo.setName(name);
            dirInfo.setDisplayName(name);
            dirInfo = this.dmcClientMap.getOrDefault(bucket, this.dmcAthenaClient).createDir(dirInfo);
        }
        catch (Exception e) {
            logger.error("DMC\u7cfb\u7edf\u521b\u5efa\u76ee\u5f55\u51fa\u9519\u4e86....dirName\uff1a" + name);
            return null;
        }
        return dirInfo;
    }

    public String segmentedUploadFile(SegmentedUploadFileDTO dto, String bucket, String token) {
        String url = String.format("%s/api/dmc/v1/buckets/%s/files/segment", AppContext.getApiUrlSetting().getDmcUrl(), bucket);
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(token), JsonUtil.javaObjectToJsonString((Object)dto), Map.class);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return String.valueOf(((Map)Objects.requireNonNull(responseEntity.getBody())).get("id"));
            }
        }
        catch (Exception e) {
            logger.error("segmentedUploadFile\u5206\u6bb5\u4e0a\u4f20-\u521b\u5efa\u7a7a\u6587\u4ef6\u5931\u8d25:{}", (Object)e.getMessage());
        }
        return null;
    }

    public String segmentUploadCreateFile(Resource resource, String token, String bucket, String fileId, Integer from, Integer to, Integer total) {
        String url = String.format("%s/api/dmc/v1/buckets/%s/files/%s/%s/%s/%s", AppContext.getApiUrlSetting().getDmcUrl(), bucket, fileId, from, to, total);
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headers.add("digi-middleware-auth-user", token);
        HttpEntity request = new HttpEntity((Object)resource, (MultiValueMap)headers);
        try {
            Map map = (Map)restTemplate.postForObject(url, (Object)request, Map.class, new Object[0]);
            if (map == null) {
                return null;
            }
            return String.valueOf(map.get("id"));
        }
        catch (RestClientException e) {
            logger.error("segmentUploadCreateFile\u5206\u6bb5\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25:{}", (Object)e.getMessage());
            return null;
        }
    }

    public List<FileInfo> getFileInfos(String dirId, String bucket) {
        try {
            return this.dmcClientMap.getOrDefault(bucket, this.dmcAthenaClient).getFileInfos(dirId);
        }
        catch (Exception e) {
            logger.error("DMC\u83b7\u53d6\u6587\u4ef6\u76ee\u5f55\u4e0b\u6587\u4ef6\u5f02\u5e38,\u76ee\u5f55ID:{},error:{}", new Object[]{dirId, e.getMessage(), e});
            return Collections.emptyList();
        }
    }

    public List<FileInfo> getFileInfoByIds(String bucket, List<String> ids) {
        try {
            return this.dmcClientMap.getOrDefault(bucket, this.dmcAthenaClient).getFileInfos(ids);
        }
        catch (Exception e) {
            logger.error("DMC\u83b7\u53d6\u6587\u4ef6\u76ee\u5f55\u4e0b\u6587\u4ef6\u5f02\u5e38\uff0cerror:{}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }

    public static void main(String[] args) {
        try {
            MessageDigest sha256MessageDigest = MessageDigest.getInstance("SHA-256");
            sha256MessageDigest.update("Athena".getBytes(StandardCharsets.UTF_8));
            byte[] tempByte = sha256MessageDigest.digest();
            sha256MessageDigest.update(tempByte);
            System.out.println(new String(Base64.getEncoder().encode(sha256MessageDigest.digest())));
            System.out.println(DigiwinDmcProxyServiceImpl.getSha256((String)"Athena"));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public static String getSha256(String str) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes(StandardCharsets.UTF_8));
            byte[] bytes = messageDigest.digest();
            messageDigest.update(bytes);
            return Base64.getEncoder().encodeToString(messageDigest.digest());
        }
        catch (Exception e) {
            logger.error("\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            return "";
        }
    }
}

