/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAllFields;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResult;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class QueryResultSet {
    private List<QueryResult> queryResults;
    private QueryResult mainQueryResult;

    public List<QueryResult> getQueryResults() {
        return this.queryResults;
    }

    public void setMainQueryResult(QueryResult mainQueryResult) {
        this.mainQueryResult = mainQueryResult;
    }

    public QueryResult getMainQueryResult() {
        if (this.mainQueryResult == null && this.queryResults.size() > 0) {
            this.mainQueryResult = (QueryResult)this.queryResults.get(0);
        }
        return this.mainQueryResult;
    }

    public String getDataSourceNameFromApiResp() {
        if (this.getMainQueryResult() == null) {
            return "";
        }
        return this.getMainQueryResult().getDataSourceNameFromApiResp();
    }

    public PcUiBotMetadataField getMasterField() {
        if (this.getMainQueryResult() == null) {
            return null;
        }
        return this.getMainQueryResult().getMasterField();
    }

    private QueryResultSet() {
    }

    public static QueryResultSet empty() {
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.queryResults = new ArrayList();
        queryResultSet.mainQueryResult = QueryResult.empty();
        return queryResultSet;
    }

    public static QueryResultSet withData(String mainDatasource, QueryResult queryResult) {
        if (queryResult == null) {
            throw new IllegalArgumentException("queryResult");
        }
        ArrayList<QueryResult> queryResultList = new ArrayList<QueryResult>();
        queryResultList.add(queryResult);
        return QueryResultSet.withData((String)mainDatasource, queryResultList);
    }

    public static QueryResultSet withData(String mainDatasource, List<QueryResult> queryResultList) {
        if (queryResultList == null) {
            throw new IllegalArgumentException("queryResultList");
        }
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.queryResults = queryResultList;
        if (StringUtils.hasText((String)mainDatasource)) {
            for (QueryResult queryResult : queryResultList) {
                if (!mainDatasource.equals(queryResult.getDataSourceName())) continue;
                queryResultSet.mainQueryResult = queryResult;
                break;
            }
        } else {
            queryResultSet.mainQueryResult = queryResultList.size() > 0 ? queryResultList.get(0) : QueryResult.empty();
        }
        return queryResultSet;
    }

    public QueryResultSet appendData(QueryResult queryResult) {
        if (queryResult == null) {
            throw new IllegalArgumentException("queryResult");
        }
        this.queryResults.add(queryResult);
        return this;
    }

    public boolean contains(String name) {
        return this.queryResults.stream().anyMatch(queryResult -> name.equals(queryResult.getDataSourceName()));
    }

    public QueryResult get(String name) {
        Optional<QueryResult> optionalQueryResult = this.queryResults.stream().filter(queryResult -> name.equals(queryResult.getDataSourceName())).findFirst();
        if (optionalQueryResult.isPresent()) {
            return optionalQueryResult.get();
        }
        return null;
    }

    public Map<String, Object> getPageData() {
        HashMap<String, Object> pageData = new HashMap<String, Object>();
        for (QueryResult queryResult : this.queryResults) {
            if (queryResult.isSingle()) {
                if (!CollectionUtils.isEmpty((Collection)queryResult.getData())) {
                    pageData.put(queryResult.getDataSourceName(), queryResult.getData().get(0));
                    continue;
                }
                pageData.put(queryResult.getDataSourceName(), new HashMap());
                continue;
            }
            pageData.put(queryResult.getDataSourceName(), queryResult.getData());
        }
        return pageData;
    }

    public Map<String, Object> getPageData(List<PcUiBotAllFields> allFields) {
        HashMap<String, Object> pageData = new HashMap<String, Object>();
        for (QueryResult queryResult : this.queryResults) {
            if (queryResult.isSingle()) {
                if (!CollectionUtils.isEmpty((Collection)queryResult.getData())) {
                    pageData.put(queryResult.getDataSourceName(), queryResult.getData().get(0));
                    continue;
                }
                pageData.put(queryResult.getDataSourceName(), this.bindEmptyPageData(allFields));
                continue;
            }
            pageData.put(queryResult.getDataSourceName(), queryResult.getData());
        }
        return pageData;
    }

    public Map<String, Map<String, Integer>> getPageDataIndex() {
        HashMap<String, Map<String, Integer>> pageData = new HashMap<String, Map<String, Integer>>();
        for (QueryResult queryResult : this.queryResults) {
            pageData.put(queryResult.getDataSourceName(), queryResult.getDataKeyIndex());
        }
        return pageData;
    }

    public Map<String, List<String>> getPageDataKeys() {
        HashMap<String, List<String>> pageDataKeys = new HashMap<String, List<String>>();
        pageDataKeys.put(this.mainQueryResult.getDataSourceName(), this.mainQueryResult.getDataKeys());
        return pageDataKeys;
    }

    @JsonIgnore
    private Map bindEmptyPageData(List<PcUiBotAllFields> allFields) {
        if (CollectionUtils.isEmpty(allFields)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Set keys = allFields.stream().map(PcUiBotAllFields::getName).collect(Collectors.toSet());
        if (keys.isEmpty()) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap pageDataMap = Maps.newHashMapWithExpectedSize((int)keys.size());
        ArrayList typeToNull = Lists.newArrayList((Object[])new String[]{"number", "numeric", "boolean", "date", "datetime"});
        for (String key : keys) {
            Optional<String> dataType = allFields.stream().filter(field -> key.equals(field.getName())).map(PcUiBotAllFields::getDataType).findAny();
            if (!dataType.isPresent()) continue;
            String type = dataType.get();
            if (typeToNull.contains(type)) {
                pageDataMap.put(key, null);
                continue;
            }
            if ("array".equals(type)) {
                pageDataMap.put(key, Lists.newArrayListWithExpectedSize((int)0));
                continue;
            }
            if ("object".equals(type)) {
                pageDataMap.put(key, Maps.newHashMapWithExpectedSize((int)0));
                continue;
            }
            pageDataMap.put(key, "");
        }
        return pageDataMap;
    }

    public List<Map<String, Object>> getQueryResultData() {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        for (QueryResult queryResult : this.queryResults) {
            if (CollectionUtils.isEmpty((Collection)queryResult.getData())) continue;
            dataList.addAll(queryResult.getData());
        }
        return dataList;
    }

    public boolean isMainQueryResultHasNext() {
        return this.getMainQueryResult() != null && this.getMainQueryResult().isHasNext();
    }
}

