/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.common.math.MathUtil;
import com.digiwin.mobile.mobileuibot.core.component.chart.ChartTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDataItem;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.DataObserveResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartFieldDisplayFormat;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartValueField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.ChartRenderSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.statsindex.IndexRenderSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.table.TableRenderSetting;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.springframework.util.CollectionUtils;

public class AgileDataIntermediateDataItem
implements Serializable {
    private static final long serialVersionUID = 7061403906084212134L;
    private Integer showCategory;
    private String showName;
    private String bizDataId;
    private List<AgileDataMetadataField> metadataFields;
    private List<JSONObject> pageData;
    private TableRenderSetting tableRenderSetting;
    private ChartRenderSetting chartRenderSetting;
    private IndexRenderSetting mobileDSLIndexRender;
    private String dataTipMessage;
    @JsonIgnore
    @JSONField(serialize=false, deserialize=false)
    private Map<Integer, DataObserveResult> dataObserveResultMap = new LinkedHashMap(2);
    private Map<Integer, List<AgileDataChartValueField>> groupedValueFields = new LinkedHashMap(2);

    public List<String> getSeriesDataWithFieldId(String fieldId) {
        return this.pageData.stream().map(j -> j.getString(fieldId)).collect(Collectors.toList());
    }

    public String getLabelWithValueField(String locale, AgileDataChartValueField valueField, Double value) {
        if (null == valueField.getFormat()) {
            return String.format("%,." + AgileDataChartFieldDisplayFormat.DEFAULT_DECIMAL + "f", value);
        }
        return valueField.getFormat().getFormattedString(value);
    }

    private boolean dataObservable() {
        return null != this.chartRenderSetting && !CollectionUtils.isEmpty((Collection)this.chartRenderSetting.getValues()) || null != this.chartRenderSetting && !Objects.equals(this.chartRenderSetting.getChartType(), ChartTypeEnum.LINE.getType()) && !Objects.equals(this.chartRenderSetting.getChartType(), ChartTypeEnum.BAR.getType()) && !Objects.equals(this.chartRenderSetting.getChartType(), ChartTypeEnum.MIXED.getType());
    }

    public void observeDataForChart(String locale) {
        if (!this.dataObservable()) {
            return;
        }
        this.normalizeChartRenderSetting();
        this.groupedValueFields = this.chartRenderSetting.getValues().stream().collect(Collectors.groupingBy(field -> field.getGroup(), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
        for (Integer groupNo : this.groupedValueFields.keySet()) {
            Double interval;
            List valueFieldList = (List)this.groupedValueFields.get(groupNo);
            DataObserveResult dataObserveResult = new DataObserveResult(locale, groupNo, ((AgileDataChartValueField)valueFieldList.get(0)).getFormat());
            this.dataObserveResultMap.put(groupNo, dataObserveResult);
            DescriptiveStatistics stats = new DescriptiveStatistics();
            for (AgileDataChartValueField valueField : valueFieldList) {
                for (JSONObject pageDatum : this.pageData) {
                    stats.addValue(pageDatum.getDoubleValue(valueField.getName()));
                }
            }
            dataObserveResult.setMinValue(Double.valueOf(stats.getMin()));
            dataObserveResult.setMaxValue(Double.valueOf(stats.getMax()));
            dataObserveResult.setMedianValue(Double.valueOf(stats.getPercentile(50.0)));
            dataObserveResult.setMeanValue(Double.valueOf(stats.getMean()));
            dataObserveResult.setStdDeviation(Double.valueOf(stats.getStandardDeviation()));
            if (stats.getMin() == stats.getMax()) {
                if (stats.getMin() == 0.0) {
                    dataObserveResult.setPreferredAxisMinValue(Double.valueOf(0.0));
                    dataObserveResult.setPreferredAxisMaxValue(Double.valueOf(1.0));
                } else if (stats.getMin() > 0.0) {
                    dataObserveResult.setPreferredAxisMinValue(Double.valueOf(0.0));
                    dataObserveResult.setPreferredAxisMaxValue(MathUtil.getFiveMultiplesRoundedValueByDigits((Double)stats.getMin(), (int)1));
                } else {
                    dataObserveResult.setPreferredAxisMinValue(MathUtil.getFiveMultiplesRoundedValueByDigits((Double)stats.getMin(), (int)-1));
                    dataObserveResult.setPreferredAxisMaxValue(Double.valueOf(0.0));
                }
            } else if (stats.getMin() >= 0.0 && stats.getMin() != stats.getMax()) {
                dataObserveResult.setPreferredAxisMinValue(Double.valueOf(0.0));
                dataObserveResult.setPreferredAxisMaxValue(MathUtil.getFiveMultiplesRoundedValueByDigits((Double)stats.getMax(), (int)1));
            } else if (stats.getMax() <= 0.0 && stats.getMin() != stats.getMax()) {
                dataObserveResult.setPreferredAxisMaxValue(Double.valueOf(0.0));
                dataObserveResult.setPreferredAxisMinValue(MathUtil.getFiveMultiplesRoundedValueByDigits((Double)stats.getMin(), (int)-1));
            } else {
                dataObserveResult.setPreferredAxisMinValue(MathUtil.getFiveMultiplesRoundedValueByDigits((Double)stats.getMin(), (int)-1));
                dataObserveResult.setPreferredAxisMaxValue(MathUtil.getFiveMultiplesRoundedValueByDigits((Double)stats.getMax(), (int)1));
            }
            int equalDivisionCount = 5;
            if (dataObserveResult.dataDistributionIsBetweenPlusAndMinusOne()) {
                interval = (dataObserveResult.getPreferredAxisMaxValue() - dataObserveResult.getPreferredAxisMinValue()) / (double)equalDivisionCount;
                dataObserveResult.setPreferredAxisInterval(interval);
            } else if (dataObserveResult.dataDistributionIsBetweenPlusAndMinusTen()) {
                interval = (dataObserveResult.getPreferredAxisMaxValue() - dataObserveResult.getPreferredAxisMinValue()) / (double)equalDivisionCount;
                if (interval > 1.0) {
                    dataObserveResult.setPreferredAxisInterval(Double.valueOf(Math.ceil(interval)));
                } else {
                    dataObserveResult.setPreferredAxisInterval(interval);
                }
            } else {
                interval = Math.ceil((dataObserveResult.getPreferredAxisMaxValue() - dataObserveResult.getPreferredAxisMinValue()) / (double)equalDivisionCount);
                dataObserveResult.setPreferredAxisInterval(interval);
            }
            dataObserveResult.tunePreferredAxisInterval();
        }
    }

    private void normalizeChartRenderSetting() {
        ChartTypeEnum chartTypeEnum = ChartTypeEnum.getEnumByValue((String)this.chartRenderSetting.getChartType());
        if (ChartTypeEnum.LINE == chartTypeEnum || ChartTypeEnum.BAR == chartTypeEnum || ChartTypeEnum.PIE == chartTypeEnum) {
            this.chartRenderSetting.getValues().forEach(v -> v.setChartType(chartTypeEnum.getType()));
        }
    }

    public void alignChartValueAxesScaleCount() {
        if (!this.dataObservable()) {
            return;
        }
        ScaleSetScanResultType scanResultType = this.getScaleScanResultType();
        switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$proxy$uibot$model$agiledata$AgileDataIntermediateDataItem$ScaleSetScanResultType[scanResultType.ordinal()]) {
            case 1: {
                for (DataObserveResult observeResult : this.dataObserveResultMap.values()) {
                    Double interval = observeResult.getPreferredAxisInterval();
                    if (observeResult.getNegativeValueAxisScaleCount() == 0 && observeResult.getPositiveValueAxisScaleCount() > 0) {
                        observeResult.setPreferredAxisMaxValue(Double.valueOf(observeResult.getPreferredAxisMaxValue() + interval));
                    }
                    if (observeResult.getNegativeValueAxisScaleCount() <= 0 || observeResult.getPositiveValueAxisScaleCount() != 0) continue;
                    observeResult.setPreferredAxisMinValue(Double.valueOf(observeResult.getPreferredAxisMinValue() - interval));
                }
                break;
            }
        }
    }

    private ScaleSetScanResultType getScaleScanResultType() {
        ScaleSetScanResultType scanResultType = null;
        int negativeScaleCount = 0;
        int positiveScaleCount = 0;
        int onlyPositiveFieldScaleCount = 0;
        int onlyNegativeFieldScaleCount = 0;
        for (DataObserveResult observeResult : this.dataObserveResultMap.values()) {
            negativeScaleCount += observeResult.getNegativeValueAxisScaleCount().intValue();
            positiveScaleCount += observeResult.getPositiveValueAxisScaleCount().intValue();
            if (observeResult.getNegativeValueAxisScaleCount() > 0 && observeResult.getPositiveValueAxisScaleCount() > 0) {
                scanResultType = ScaleSetScanResultType.EXIST_NEGATIVE_AND_POSITIVE;
                break;
            }
            if (observeResult.getNegativeValueAxisScaleCount() == 0 && observeResult.getPositiveValueAxisScaleCount() > 0) {
                ++onlyPositiveFieldScaleCount;
            }
            if (observeResult.getNegativeValueAxisScaleCount() <= 0 || observeResult.getPositiveValueAxisScaleCount() != 0) continue;
            ++onlyNegativeFieldScaleCount;
        }
        if (null != scanResultType) {
            return scanResultType;
        }
        scanResultType = negativeScaleCount > 0 && positiveScaleCount == 0 ? ScaleSetScanResultType.ONLY_NEGATIVE : (negativeScaleCount == 0 && positiveScaleCount > 0 ? ScaleSetScanResultType.ONLY_POSITIVE : (onlyPositiveFieldScaleCount + onlyNegativeFieldScaleCount == this.dataObserveResultMap.size() ? ScaleSetScanResultType.ONLY_ONE_DIRECTION_AND_EXIST_OPPOSITE_DIRECTION : ScaleSetScanResultType.NONE));
        return scanResultType;
    }

    private Integer getMaxPositiveScaleCount() {
        Integer maxPositiveScaleCount = 0;
        for (DataObserveResult observeResult : this.dataObserveResultMap.values()) {
            maxPositiveScaleCount = Math.max(maxPositiveScaleCount, observeResult.getPositiveValueAxisScaleCount());
        }
        return maxPositiveScaleCount;
    }

    private Integer getMaxNegativeScaleCount() {
        Integer maxNegativeScaleCount = 0;
        for (DataObserveResult observeResult : this.dataObserveResultMap.values()) {
            maxNegativeScaleCount = Math.max(maxNegativeScaleCount, observeResult.getNegativeValueAxisScaleCount());
        }
        return maxNegativeScaleCount;
    }

    public DataObserveResult getExactDataObserveResult(Integer groupNo) {
        if (this.dataObserveResultMap.isEmpty()) {
            return null;
        }
        for (Integer group : this.dataObserveResultMap.keySet()) {
            if (!Objects.equals(groupNo, group)) continue;
            return (DataObserveResult)this.dataObserveResultMap.get(group);
        }
        return null;
    }

    public Integer getShowCategory() {
        return this.showCategory;
    }

    public String getShowName() {
        return this.showName;
    }

    public String getBizDataId() {
        return this.bizDataId;
    }

    public List<AgileDataMetadataField> getMetadataFields() {
        return this.metadataFields;
    }

    public List<JSONObject> getPageData() {
        return this.pageData;
    }

    public TableRenderSetting getTableRenderSetting() {
        return this.tableRenderSetting;
    }

    public ChartRenderSetting getChartRenderSetting() {
        return this.chartRenderSetting;
    }

    public IndexRenderSetting getMobileDSLIndexRender() {
        return this.mobileDSLIndexRender;
    }

    public String getDataTipMessage() {
        return this.dataTipMessage;
    }

    public Map<Integer, DataObserveResult> getDataObserveResultMap() {
        return this.dataObserveResultMap;
    }

    public Map<Integer, List<AgileDataChartValueField>> getGroupedValueFields() {
        return this.groupedValueFields;
    }

    public void setShowCategory(Integer showCategory) {
        this.showCategory = showCategory;
    }

    public void setShowName(String showName) {
        this.showName = showName;
    }

    public void setBizDataId(String bizDataId) {
        this.bizDataId = bizDataId;
    }

    public void setMetadataFields(List<AgileDataMetadataField> metadataFields) {
        this.metadataFields = metadataFields;
    }

    public void setPageData(List<JSONObject> pageData) {
        this.pageData = pageData;
    }

    public void setTableRenderSetting(TableRenderSetting tableRenderSetting) {
        this.tableRenderSetting = tableRenderSetting;
    }

    public void setChartRenderSetting(ChartRenderSetting chartRenderSetting) {
        this.chartRenderSetting = chartRenderSetting;
    }

    public void setMobileDSLIndexRender(IndexRenderSetting mobileDSLIndexRender) {
        this.mobileDSLIndexRender = mobileDSLIndexRender;
    }

    public void setDataTipMessage(String dataTipMessage) {
        this.dataTipMessage = dataTipMessage;
    }

    @JsonIgnore
    public void setDataObserveResultMap(Map<Integer, DataObserveResult> dataObserveResultMap) {
        this.dataObserveResultMap = dataObserveResultMap;
    }

    public void setGroupedValueFields(Map<Integer, List<AgileDataChartValueField>> groupedValueFields) {
        this.groupedValueFields = groupedValueFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgileDataIntermediateDataItem)) {
            return false;
        }
        AgileDataIntermediateDataItem other = (AgileDataIntermediateDataItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$showCategory = this.getShowCategory();
        Integer other$showCategory = other.getShowCategory();
        if (this$showCategory == null ? other$showCategory != null : !((Object)this$showCategory).equals(other$showCategory)) {
            return false;
        }
        String this$showName = this.getShowName();
        String other$showName = other.getShowName();
        if (this$showName == null ? other$showName != null : !this$showName.equals(other$showName)) {
            return false;
        }
        String this$bizDataId = this.getBizDataId();
        String other$bizDataId = other.getBizDataId();
        if (this$bizDataId == null ? other$bizDataId != null : !this$bizDataId.equals(other$bizDataId)) {
            return false;
        }
        List this$metadataFields = this.getMetadataFields();
        List other$metadataFields = other.getMetadataFields();
        if (this$metadataFields == null ? other$metadataFields != null : !((Object)this$metadataFields).equals(other$metadataFields)) {
            return false;
        }
        List this$pageData = this.getPageData();
        List other$pageData = other.getPageData();
        if (this$pageData == null ? other$pageData != null : !((Object)this$pageData).equals(other$pageData)) {
            return false;
        }
        TableRenderSetting this$tableRenderSetting = this.getTableRenderSetting();
        TableRenderSetting other$tableRenderSetting = other.getTableRenderSetting();
        if (this$tableRenderSetting == null ? other$tableRenderSetting != null : !this$tableRenderSetting.equals(other$tableRenderSetting)) {
            return false;
        }
        ChartRenderSetting this$chartRenderSetting = this.getChartRenderSetting();
        ChartRenderSetting other$chartRenderSetting = other.getChartRenderSetting();
        if (this$chartRenderSetting == null ? other$chartRenderSetting != null : !this$chartRenderSetting.equals(other$chartRenderSetting)) {
            return false;
        }
        IndexRenderSetting this$mobileDSLIndexRender = this.getMobileDSLIndexRender();
        IndexRenderSetting other$mobileDSLIndexRender = other.getMobileDSLIndexRender();
        if (this$mobileDSLIndexRender == null ? other$mobileDSLIndexRender != null : !this$mobileDSLIndexRender.equals(other$mobileDSLIndexRender)) {
            return false;
        }
        String this$dataTipMessage = this.getDataTipMessage();
        String other$dataTipMessage = other.getDataTipMessage();
        if (this$dataTipMessage == null ? other$dataTipMessage != null : !this$dataTipMessage.equals(other$dataTipMessage)) {
            return false;
        }
        Map this$dataObserveResultMap = this.getDataObserveResultMap();
        Map other$dataObserveResultMap = other.getDataObserveResultMap();
        if (this$dataObserveResultMap == null ? other$dataObserveResultMap != null : !((Object)this$dataObserveResultMap).equals(other$dataObserveResultMap)) {
            return false;
        }
        Map this$groupedValueFields = this.getGroupedValueFields();
        Map other$groupedValueFields = other.getGroupedValueFields();
        return !(this$groupedValueFields == null ? other$groupedValueFields != null : !((Object)this$groupedValueFields).equals(other$groupedValueFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgileDataIntermediateDataItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $showCategory = this.getShowCategory();
        result = result * 59 + ($showCategory == null ? 43 : ((Object)$showCategory).hashCode());
        String $showName = this.getShowName();
        result = result * 59 + ($showName == null ? 43 : $showName.hashCode());
        String $bizDataId = this.getBizDataId();
        result = result * 59 + ($bizDataId == null ? 43 : $bizDataId.hashCode());
        List $metadataFields = this.getMetadataFields();
        result = result * 59 + ($metadataFields == null ? 43 : ((Object)$metadataFields).hashCode());
        List $pageData = this.getPageData();
        result = result * 59 + ($pageData == null ? 43 : ((Object)$pageData).hashCode());
        TableRenderSetting $tableRenderSetting = this.getTableRenderSetting();
        result = result * 59 + ($tableRenderSetting == null ? 43 : $tableRenderSetting.hashCode());
        ChartRenderSetting $chartRenderSetting = this.getChartRenderSetting();
        result = result * 59 + ($chartRenderSetting == null ? 43 : $chartRenderSetting.hashCode());
        IndexRenderSetting $mobileDSLIndexRender = this.getMobileDSLIndexRender();
        result = result * 59 + ($mobileDSLIndexRender == null ? 43 : $mobileDSLIndexRender.hashCode());
        String $dataTipMessage = this.getDataTipMessage();
        result = result * 59 + ($dataTipMessage == null ? 43 : $dataTipMessage.hashCode());
        Map $dataObserveResultMap = this.getDataObserveResultMap();
        result = result * 59 + ($dataObserveResultMap == null ? 43 : ((Object)$dataObserveResultMap).hashCode());
        Map $groupedValueFields = this.getGroupedValueFields();
        result = result * 59 + ($groupedValueFields == null ? 43 : ((Object)$groupedValueFields).hashCode());
        return result;
    }

    public String toString() {
        return "AgileDataIntermediateDataItem(showCategory=" + this.getShowCategory() + ", showName=" + this.getShowName() + ", bizDataId=" + this.getBizDataId() + ", metadataFields=" + this.getMetadataFields() + ", pageData=" + this.getPageData() + ", tableRenderSetting=" + this.getTableRenderSetting() + ", chartRenderSetting=" + this.getChartRenderSetting() + ", mobileDSLIndexRender=" + this.getMobileDSLIndexRender() + ", dataTipMessage=" + this.getDataTipMessage() + ", dataObserveResultMap=" + this.getDataObserveResultMap() + ", groupedValueFields=" + this.getGroupedValueFields() + ")";
    }
}

